/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bom.decomposer;

import io.quarkus.bom.PomResolver;
import io.quarkus.bom.PomSource;
import io.quarkus.bom.decomposer.BomDecomposerException;
import io.quarkus.bom.decomposer.DecomposedBom;
import io.quarkus.bom.decomposer.DecomposedBomBuilder;
import io.quarkus.bom.decomposer.DecomposedBomTransformer;
import io.quarkus.bom.decomposer.DefaultDecomposedBomBuilder;
import io.quarkus.bom.decomposer.ReleaseIdDetector;
import io.quarkus.bom.decomposer.UpdateAvailabilityTransformer;
import io.quarkus.bom.resolver.ArtifactNotFoundException;
import io.quarkus.bom.resolver.ArtifactResolver;
import io.quarkus.bom.resolver.ArtifactResolverProvider;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.domino.scm.ScmRevision;
import io.quarkus.domino.scm.ScmRevisionResolver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResult;

public class BomDecomposer {
    private MessageWriter logger;
    private boolean debug;
    private Artifact bomArtifact;
    private PomResolver bomSource;
    private Collection<Dependency> artifacts;
    private ArtifactResolver mvnResolver;
    private ProjectModelResolver modelResolver;
    private List<ReleaseIdDetector> releaseDetectors = new ArrayList<ReleaseIdDetector>();
    private DecomposedBomBuilder decomposedBuilder;
    private DecomposedBomTransformer transformer;
    private ScmRevisionResolver revisionResolver;

    public static boolean isParallelProcessing() {
        return Boolean.getBoolean("parallelProcessing");
    }

    public static BomDecomposerConfig config() {
        return new BomDecomposer().new BomDecomposerConfig();
    }

    private BomDecomposer() {
    }

    private ArtifactResolver artifactResolver() {
        try {
            return this.mvnResolver == null ? (this.mvnResolver = ArtifactResolverProvider.get(((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setArtifactTransferLogging(this.debug)).build())) : this.mvnResolver;
        }
        catch (BootstrapMavenException e) {
            throw new RuntimeException("Failed to initialize Maven artifact resolver", e);
        }
    }

    private DecomposedBom decompose() throws BomDecomposerException {
        Collection<Dependency> artifacts;
        DecomposedBomBuilder bomBuilder = this.decomposedBuilder == null ? new DefaultDecomposedBomBuilder() : this.decomposedBuilder;
        bomBuilder.bomArtifact(this.bomArtifact);
        Collection<Dependency> collection = artifacts = this.artifacts == null ? this.bomManagedDeps() : this.artifacts;
        if (BomDecomposer.isParallelProcessing()) {
            this.addConcurrently(bomBuilder, artifacts);
        } else {
            for (Dependency dep : artifacts) {
                this.addDependency(bomBuilder, dep);
            }
        }
        return this.transformer == null ? bomBuilder.build() : this.transformer.transform(bomBuilder.build());
    }

    private void addConcurrently(DecomposedBomBuilder bomBuilder, Collection<Dependency> deps) {
        ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>(deps.size());
        ConcurrentLinkedDeque failed = new ConcurrentLinkedDeque();
        for (Dependency dep : deps) {
            tasks.add(CompletableFuture.runAsync(() -> {
                try {
                    this.addDependency(bomBuilder, dep);
                }
                catch (Exception e) {
                    failed.add(Map.entry(dep, e));
                }
            }));
        }
        CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).join();
        if (!failed.isEmpty()) {
            for (Map.Entry d : failed) {
                this.logger.error("Failed to process dependency " + d.getKey(), new Object[]{d.getValue()});
            }
            throw new RuntimeException("Failed to process dependencies reported above");
        }
    }

    private void addDependency(DecomposedBomBuilder bomBuilder, Dependency dep) throws BomDecomposerException {
        try {
            this.validateArtifact(dep.getArtifact());
            ScmRevision revision = this.resolveRevision(dep.getArtifact());
            bomBuilder.bomDependency(revision, dep);
        }
        catch (ArtifactNotFoundException e) {
            this.logger().debug("Failed to resolve %s", new Object[]{dep});
        }
    }

    private ScmRevision resolveRevision(Artifact artifact) throws BomDecomposerException {
        return this.revisionResolver.resolveRevision(artifact, List.of());
    }

    private void validateArtifact(Artifact artifact) throws BomDecomposerException {
        Model model;
        String classifier = artifact.getClassifier();
        if (!(classifier.isEmpty() || classifier.equals("sources") || classifier.equals("javadoc"))) {
            this.resolve(artifact);
        } else if ("jar".equals(artifact.getExtension()) && "pom".equals((model = this.revisionResolver.readPom(artifact)).getPackaging())) {
            try {
                this.resolve(artifact);
            }
            catch (ArtifactNotFoundException e) {
                DistributionManagement distr = model.getDistributionManagement();
                if (distr == null || distr.getRelocation() == null) {
                    throw e;
                }
                this.logger().debug("Found relocation for %s", new Object[]{artifact});
            }
        }
    }

    private List<Dependency> bomManagedDeps() {
        return this.describe(this.bomArtifact).getManagedDependencies();
    }

    public MessageWriter logger() {
        return this.logger == null ? (this.logger = MessageWriter.debug()) : this.logger;
    }

    private ArtifactDescriptorResult describe(Artifact artifact) {
        return this.artifactResolver().describe(artifact);
    }

    private ArtifactResult resolve(Artifact artifact) {
        return this.artifactResolver().resolve(artifact);
    }

    private ProjectModelResolver getModelResolver() {
        if (this.modelResolver == null) {
            MavenArtifactResolver mvn = this.artifactResolver().underlyingResolver();
            this.modelResolver = new ProjectModelResolver(mvn.getSession(), new RequestTrace(null), mvn.getSystem(), mvn.getRemoteRepositoryManager(), mvn.getRepositories(), ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null);
        }
        return this.modelResolver;
    }

    public class BomDecomposerConfig {
        boolean loadReleaseDetectors = true;

        private BomDecomposerConfig() {
        }

        public BomDecomposerConfig logger(MessageWriter messageWriter) {
            BomDecomposer.this.logger = messageWriter;
            return this;
        }

        public BomDecomposerConfig debug() {
            BomDecomposer.this.debug = true;
            return this;
        }

        public BomDecomposerConfig mavenArtifactResolver(ArtifactResolver resolver) {
            BomDecomposer.this.mvnResolver = resolver;
            return this;
        }

        public BomDecomposerConfig bomFile(Path bom) {
            MavenArtifactResolver underlyingResolver;
            MavenArtifactResolver.Builder resolverBuilder = (MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setCurrentProject(bom.normalize().toAbsolutePath().toString());
            if (BomDecomposer.this.mvnResolver != null) {
                MavenArtifactResolver baseResolver = BomDecomposer.this.mvnResolver.underlyingResolver();
                ((MavenArtifactResolver.Builder)resolverBuilder.setRepositorySystem(baseResolver.getSystem())).setRemoteRepositoryManager(baseResolver.getRemoteRepositoryManager());
            }
            try {
                underlyingResolver = resolverBuilder.build();
            }
            catch (BootstrapMavenException e) {
                throw new RuntimeException("Failed to initialize Maven artifact resolver for " + bom, e);
            }
            this.mavenArtifactResolver(ArtifactResolverProvider.get(underlyingResolver, BomDecomposer.this.mvnResolver == null ? null : BomDecomposer.this.mvnResolver.getBaseDir()));
            BootstrapMavenContext mvnCtx = underlyingResolver.getMavenContext();
            LocalProject bomProject = mvnCtx.getCurrentProject();
            BomDecomposer.this.bomArtifact = new DefaultArtifact(bomProject.getGroupId(), bomProject.getArtifactId(), "", "pom", bomProject.getVersion());
            BomDecomposer.this.bomArtifact = BomDecomposer.this.bomArtifact.setFile(bom.toFile());
            BomDecomposer.this.bomSource = PomSource.of(bom);
            return this;
        }

        public BomDecomposerConfig bomArtifact(String groupId, String artifactId, String version) {
            return this.bomArtifact((Artifact)new DefaultArtifact(groupId, artifactId, "", "pom", version));
        }

        public BomDecomposerConfig bomArtifact(Artifact artifact) {
            BomDecomposer.this.bomArtifact = artifact;
            BomDecomposer.this.bomSource = PomSource.of(artifact);
            return this;
        }

        public BomDecomposerConfig addReleaseDetector(ReleaseIdDetector releaseDetector) {
            BomDecomposer.this.releaseDetectors.add(releaseDetector);
            return this;
        }

        public BomDecomposerConfig checkForUpdates() {
            return this.transform(new UpdateAvailabilityTransformer(BomDecomposer.this.mvnResolver, BomDecomposer.this.logger));
        }

        public BomDecomposerConfig transform(DecomposedBomTransformer bomTransformer) {
            BomDecomposer.this.transformer = bomTransformer;
            return this;
        }

        public BomDecomposerConfig dependencies(Collection<Dependency> iterator) {
            BomDecomposer.this.artifacts = iterator;
            return this;
        }

        public BomDecomposerConfig loadReleaseDetectors(boolean loadReleaseDetectors) {
            this.loadReleaseDetectors = loadReleaseDetectors;
            return this;
        }

        public DecomposedBom decompose() throws BomDecomposerException {
            if (this.loadReleaseDetectors) {
                ServiceLoader.load(ReleaseIdDetector.class, Thread.currentThread().getContextClassLoader()).forEach(d -> {
                    BomDecomposer.this.logger().debug("Loaded release detector " + d);
                    BomDecomposer.this.releaseDetectors.add((ReleaseIdDetector)d);
                });
            }
            BomDecomposer.this.revisionResolver = new ScmRevisionResolver(BomDecomposer.this.artifactResolver(), BomDecomposer.this.releaseDetectors);
            return BomDecomposer.this.decompose();
        }
    }
}

