/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.mock.impl;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.mock.PanacheMock;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class PanacheMockMethodCustomizer
implements PanacheMethodCustomizer {
    private static final String PANACHE_MOCK_BINARY_NAME = PanacheMock.class.getName().replace('.', '/');
    private static final String PANACHE_MOCK_INVOKE_REAL_METHOD_EXCEPTION_BINARY_NAME = PanacheMock.InvokeRealMethodException.class.getName().replace('.', '/');

    public void customize(org.objectweb.asm.Type entityClassSignature, MethodInfo method, MethodVisitor mv) {
        Label realMethodLabel = new Label();
        mv.visitFieldInsn(178, PANACHE_MOCK_BINARY_NAME, "IsMockEnabled", "Z");
        mv.visitJumpInsn(153, realMethodLabel);
        mv.visitLdcInsn((Object)entityClassSignature);
        mv.visitMethodInsn(184, PANACHE_MOCK_BINARY_NAME, "isMocked", "(Ljava/lang/Class;)Z", false);
        mv.visitJumpInsn(153, realMethodLabel);
        Label tryStart = new Label();
        Label tryEnd = new Label();
        Label tryHandler = new Label();
        mv.visitTryCatchBlock(tryStart, tryEnd, tryHandler, PANACHE_MOCK_INVOKE_REAL_METHOD_EXCEPTION_BINARY_NAME);
        mv.visitLabel(tryStart);
        mv.visitLdcInsn((Object)entityClassSignature);
        mv.visitLdcInsn((Object)method.name());
        mv.visitLdcInsn((Object)method.parametersCount());
        mv.visitTypeInsn(189, "java/lang/Class");
        int i = 0;
        for (Type paramType : method.parameterTypes()) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            AsmUtil.visitLdc((MethodVisitor)mv, (Type)paramType);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitLdcInsn((Object)method.parametersCount());
        mv.visitTypeInsn(189, "java/lang/Object");
        i = 0;
        int paramSlot = 0;
        for (Type paramType : method.parameterTypes()) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitVarInsn(AsmUtil.getLoadOpcode((Type)paramType), paramSlot);
            AsmUtil.boxIfRequired((MethodVisitor)mv, (Type)paramType);
            mv.visitInsn(83);
            ++i;
            paramSlot += AsmUtil.getParameterSize((Type)paramType);
        }
        mv.visitMethodInsn(184, PANACHE_MOCK_BINARY_NAME, "mockMethod", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/Object;", false);
        AsmUtil.unboxIfRequired((MethodVisitor)mv, (Type)method.returnType());
        if (method.returnType().kind() != Type.Kind.PRIMITIVE) {
            mv.visitTypeInsn(192, method.returnType().name().toString('/'));
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)method.returnType()));
        mv.visitLabel(tryHandler);
        mv.visitInsn(87);
        mv.visitLabel(tryEnd);
        mv.visitLabel(realMethodLabel);
    }
}

