/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.graphql.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.oidc.client.OidcClients;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.graphql.client.impl.GraphQLClientsConfiguration;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.util.Map;

@Recorder
public class OidcGraphQLClientIntegrationRecorder {
    public void enhanceGraphQLClientConfigurationWithOidc(Map<String, String> configKeysToOidcClients, String defaultOidcClientName) {
        OidcClients oidcClients = (OidcClients)Arc.container().instance(OidcClients.class, new Annotation[0]).get();
        GraphQLClientsConfiguration configs = GraphQLClientsConfiguration.getInstance();
        configs.getClients().forEach((graphQLClientKey, value) -> {
            String oidcClient = (String)configKeysToOidcClients.get(graphQLClientKey);
            if (oidcClient == null) {
                oidcClient = defaultOidcClientName;
            }
            Map dynamicHeaders = configs.getClient(graphQLClientKey).getDynamicHeaders();
            dynamicHeaders.put("Authorization", this.getToken(oidcClients, oidcClient));
        });
    }

    public Uni<String> getToken(OidcClients clients, String oidcClientId) {
        if (oidcClientId == null) {
            return clients.getClient().getTokens().map(Tokens::getAccessToken).map(token -> "Bearer " + token);
        }
        return clients.getClient(oidcClientId).getTokens().map(Tokens::getAccessToken).map(token -> "Bearer " + token);
    }
}

