/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.lra.runtime;

import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipant;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipantRegistry;
import io.quarkus.narayana.lra.runtime.LRAConfiguration;
import io.quarkus.runtime.annotations.Recorder;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;

@Recorder
public class NarayanaLRARecorder {
    private static final Logger log = Logger.getLogger(NarayanaLRARecorder.class);
    static LRAParticipantRegistry registry;

    public void setConfig(LRAConfiguration config) {
        if (System.getProperty("lra.coordinator.url") == null) {
            System.setProperty("lra.coordinator.url", config.coordinatorURL());
        }
    }

    public void setParticipantTypes(List<String> classNames) {
        HashMap<String, LRAParticipant> nonJaxParticipants = new HashMap<String, LRAParticipant>();
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                LRAParticipant lraParticipant = new LRAParticipant(clazz);
                nonJaxParticipants.put(className, lraParticipant);
            }
            catch (ClassNotFoundException e) {
                log.errorf("Unable to proxy class %s (%s)", (Object)className, (Object)e.getMessage());
            }
        }
        registry = new LRAParticipantRegistry(nonJaxParticipants);
    }
}

