/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta;

import io.quarkus.narayana.jta.BeginOptions;
import io.quarkus.narayana.jta.QuarkusTransaction;
import io.quarkus.narayana.jta.QuarkusTransactionException;
import io.quarkus.narayana.jta.RunOptions;
import io.quarkus.narayana.jta.runtime.TransactionManagerConfiguration;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.util.function.Function;
import org.jboss.logging.Logger;

@RequestScoped
class RequestScopedTransaction {
    private static final Logger log = Logger.getLogger(RequestScopedTransaction.class);
    public static final Function<Throwable, RunOptions.ExceptionResult> DEFAULT_HANDLER = e -> RunOptions.ExceptionResult.ROLLBACK;
    private final UserTransaction userTransaction;
    private final TransactionManager transactionManager;
    private final TransactionManagerConfiguration transactionManagerConfiguration;
    private Transaction createdTransaction;
    boolean autoCommit;

    @Inject
    public RequestScopedTransaction(UserTransaction userTransaction, TransactionManager transactionManager, TransactionManagerConfiguration transactionManagerConfiguration) {
        this.userTransaction = userTransaction;
        this.transactionManager = transactionManager;
        this.transactionManagerConfiguration = transactionManagerConfiguration;
    }

    public RequestScopedTransaction() {
        this.userTransaction = null;
        this.transactionManagerConfiguration = null;
        this.transactionManager = null;
    }

    void begin(BeginOptions options) {
        int timeout = options != null ? options.timeout : 0;
        boolean commitOnRequestScopeEnd = options != null && options.commitOnRequestScopeEnd;
        try {
            if (this.userTransaction.getStatus() != 6) {
                throw new QuarkusTransactionException("Transaction already active");
            }
            this.autoCommit = commitOnRequestScopeEnd;
            if (timeout > 0) {
                this.userTransaction.setTransactionTimeout(timeout);
            }
            this.userTransaction.begin();
            this.createdTransaction = this.transactionManager.getTransaction();
        }
        catch (NotSupportedException | SystemException e) {
            throw new QuarkusTransactionException(e);
        }
        finally {
            if (timeout > 0) {
                try {
                    this.userTransaction.setTransactionTimeout((int)this.transactionManagerConfiguration.defaultTransactionTimeout.toSeconds());
                }
                catch (SystemException e) {
                    throw new QuarkusTransactionException(e);
                }
            }
        }
    }

    @PreDestroy
    void destroy() {
        block5: {
            try {
                if (this.transactionManager.getTransaction() != this.createdTransaction) break block5;
                if (this.autoCommit) {
                    QuarkusTransaction.commit();
                    break block5;
                }
                log.warn((Object)"Rolling back transaction that was not committed or explicitly rolled back.");
                try {
                    this.userTransaction.rollback();
                }
                catch (SystemException e) {
                    throw new QuarkusTransactionException(e);
                }
            }
            catch (SystemException e) {
                log.warn((Object)"Failed to destroy request scoped transaction", (Throwable)e);
            }
        }
    }
}

