/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.deployment;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.internal.arjuna.coordinator.CheckedActionFactoryImple;
import com.arjuna.ats.internal.arjuna.objectstore.ShadowNoFileLockStore;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCImple_driver;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStore;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionExpiryScanner;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner;
import com.arjuna.ats.internal.arjuna.utils.SocketProcessId;
import com.arjuna.ats.internal.jta.recovery.arjunacore.CommitMarkableResourceRecordRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTAActionStatusServiceXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTANodeNameXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.JTATransactionLogXAResourceOrphanFilter;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoverConnectableAtomicAction;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionSynchronizationRegistryImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.UserTransactionImple;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.narayana.jta.deployment.NarayanaInitBuildItem;
import io.quarkus.narayana.jta.runtime.NarayanaJtaProducers;
import io.quarkus.narayana.jta.runtime.NarayanaJtaRecorder;
import io.quarkus.narayana.jta.runtime.TransactionManagerBuildTimeConfig;
import io.quarkus.narayana.jta.runtime.TransactionManagerConfiguration;
import io.quarkus.narayana.jta.runtime.context.TransactionContext;
import io.quarkus.narayana.jta.runtime.graal.DisableLoggingFeature;
import io.quarkus.narayana.jta.runtime.interceptor.TestTransactionInterceptor;
import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorMandatory;
import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorNever;
import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorNotSupported;
import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorRequired;
import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorRequiresNew;
import io.quarkus.narayana.jta.runtime.interceptor.TransactionalInterceptorSupports;
import io.quarkus.runtime.ShutdownContext;
import io.smallrye.context.jta.context.propagation.JtaContextProvider;
import jakarta.annotation.Priority;
import jakarta.interceptor.Interceptor;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionScoped;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class NarayanaJtaProcessor {
    private static final String TEST_TRANSACTION = "io.quarkus.test.TestTransaction";

    NarayanaJtaProcessor() {
    }

    @BuildStep
    public NativeImageSystemPropertyBuildItem nativeImageSystemPropertyBuildItem() {
        return new NativeImageSystemPropertyBuildItem("CoordinatorEnvironmentBean.transactionStatusManagerEnable", "false");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Produce(value=NarayanaInitBuildItem.class)
    public void build(NarayanaJtaRecorder recorder, CombinedIndexBuildItem indexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInit, BuildProducer<FeatureBuildItem> feature, BuildProducer<LogCleanupFilterBuildItem> logCleanupFilters, BuildProducer<NativeImageFeatureBuildItem> nativeImageFeatures, TransactionManagerConfiguration transactions, TransactionManagerBuildTimeConfig transactionManagerBuildTimeConfig, ShutdownContextBuildItem shutdownContextBuildItem, Capabilities capabilities) {
        recorder.handleShutdown((ShutdownContext)shutdownContextBuildItem, transactions);
        feature.produce((BuildItem)new FeatureBuildItem(Feature.NARAYANA_JTA));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{NarayanaJtaProducers.class}));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((String)"io.quarkus.narayana.jta.RequestScopedTransaction"));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.arjuna.ats.internal.jta.resources.arjunacore.CommitMarkableResourceRecord"));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(SocketProcessId.class.getName()));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(CommitMarkableResourceRecordRecoveryModule.class.getName()));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(RecoverConnectableAtomicAction.class.getName()));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(TransactionStatusConnectionManager.class.getName()));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(JTAActionStatusServiceXAResourceOrphanFilter.class.getName()));
        runtimeInit.produce((BuildItem)new RuntimeInitializedClassBuildItem(AtomicActionExpiryScanner.class.getName()));
        indexBuildItem.getIndex().getAllKnownSubclasses(JDBCImple_driver.class).stream().map(impl -> ReflectiveClassBuildItem.builder((String[])new String[]{impl.name().toString()}).build()).forEach(arg_0 -> reflectiveClass.produce(arg_0));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JTAEnvironmentBean.class, UserTransactionImple.class, CheckedActionFactoryImple.class, TransactionManagerImple.class, TransactionSynchronizationRegistryImple.class, ObjectStoreEnvironmentBean.class, ShadowNoFileLockStore.class, JDBCStore.class, SocketProcessId.class, AtomicActionRecoveryModule.class, XARecoveryModule.class, XAResourceRecord.class, JTATransactionLogXAResourceOrphanFilter.class, JTANodeNameXAResourceOrphanFilter.class, JTAActionStatusServiceXAResourceOrphanFilter.class, ExpiredTransactionStatusManagerScanner.class}).publicConstructors().reason(this.getClass().getName()).build());
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        builder.addBeanClass(TransactionalInterceptorSupports.class);
        builder.addBeanClass(TransactionalInterceptorNever.class);
        builder.addBeanClass(TransactionalInterceptorRequired.class);
        builder.addBeanClass(TransactionalInterceptorRequiresNew.class);
        builder.addBeanClass(TransactionalInterceptorMandatory.class);
        builder.addBeanClass(TransactionalInterceptorNotSupported.class);
        additionalBeans.produce((BuildItem)builder.build());
        transactionManagerBuildTimeConfig.unsafeMultipleLastResources.ifPresent(mode -> {
            if (!mode.equals((Object)TransactionManagerBuildTimeConfig.UnsafeMultipleLastResourcesMode.FAIL)) {
                recorder.logUnsafeMultipleLastResourcesOnStartup(mode);
            }
        });
        Properties defaultProperties = PropertiesFactory.getDefaultProperties();
        for (Object i : System.getProperties().keySet()) {
            defaultProperties.remove(i);
        }
        recorder.setDefaultProperties(defaultProperties);
        recorder.disableTransactionStatusManager();
        this.allowUnsafeMultipleLastResources(recorder, transactionManagerBuildTimeConfig, capabilities, logCleanupFilters, nativeImageFeatures);
        recorder.setNodeName(transactions);
        recorder.setDefaultTimeout(transactions);
        recorder.setConfig(transactions);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void nativeImageFeature(TransactionManagerBuildTimeConfig transactionManagerBuildTimeConfig, BuildProducer<NativeImageFeatureBuildItem> nativeImageFeatures) {
        switch (transactionManagerBuildTimeConfig.unsafeMultipleLastResources.orElse(TransactionManagerBuildTimeConfig.UnsafeMultipleLastResourcesMode.DEFAULT)) {
            case ALLOW: 
            case WARN_FIRST: 
            case WARN_EACH: {
                nativeImageFeatures.produce((BuildItem)new NativeImageFeatureBuildItem(DisableLoggingFeature.class));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume.List(value={@Consume(value=NarayanaInitBuildItem.class), @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)})
    public void startRecoveryService(NarayanaJtaRecorder recorder, List<JdbcDataSourceBuildItem> jdbcDataSourceBuildItems, TransactionManagerConfiguration transactions) {
        Map configuredDataSourcesConfigKeys = jdbcDataSourceBuildItems.stream().map(j -> j.getName()).collect(Collectors.toMap(Function.identity(), n -> DataSourceUtil.dataSourcePropertyKey((String)n, (String)"jdbc.transactions")));
        Set dataSourcesWithTransactionIntegration = jdbcDataSourceBuildItems.stream().filter(j -> j.isTransactionIntegrationEnabled()).map(j -> j.getName()).collect(Collectors.toSet());
        recorder.startRecoveryService(transactions, configuredDataSourcesConfigKeys, dataSourcesWithTransactionIntegration);
    }

    @BuildStep(onlyIf={IsTest.class})
    void testTx(BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (!NarayanaJtaProcessor.testTransactionOnClassPath()) {
            return;
        }
        try (ClassCreator c = ClassCreator.builder().classOutput((ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer)).className(TestTransactionInterceptor.class.getName() + "Generated").superClass(TestTransactionInterceptor.class).build();){
            c.addAnnotation(TEST_TRANSACTION);
            c.addAnnotation(Interceptor.class.getName());
            c.addAnnotation(Priority.class).addValue("value", (Object)200);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(TestTransactionInterceptor.class).addBeanClass(TEST_TRANSACTION).build());
    }

    private static boolean testTransactionOnClassPath() {
        try {
            Class.forName(TEST_TRANSACTION, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @BuildStep
    public ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem transactionContext(ContextRegistrationPhaseBuildItem contextRegistrationPhase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{contextRegistrationPhase.getContext().configure(TransactionScoped.class).normal().contextClass(TransactionContext.class)});
    }

    @BuildStep
    public CustomScopeBuildItem registerScope() {
        return new CustomScopeBuildItem(TransactionScoped.class);
    }

    @BuildStep
    void unremovableBean(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{JtaContextProvider.LifecycleManager.class.getName()}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TransactionManager.class}));
    }

    @BuildStep
    void logCleanupFilters(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilters) {
        logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("com.arjuna.ats.jbossatx", new String[]{"ARJUNA032010:", "ARJUNA032013:"}));
    }

    private void allowUnsafeMultipleLastResources(NarayanaJtaRecorder recorder, TransactionManagerBuildTimeConfig transactionManagerBuildTimeConfig, Capabilities capabilities, BuildProducer<LogCleanupFilterBuildItem> logCleanupFilters, BuildProducer<NativeImageFeatureBuildItem> nativeImageFeatures) {
        switch (transactionManagerBuildTimeConfig.unsafeMultipleLastResources.orElse(TransactionManagerBuildTimeConfig.UnsafeMultipleLastResourcesMode.DEFAULT)) {
            case ALLOW: {
                recorder.allowUnsafeMultipleLastResources(capabilities.isPresent("io.quarkus.agroal"), true);
                logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("com.arjuna.ats.arjuna", new String[]{"ARJUNA012139", "ARJUNA012141", "ARJUNA012142"}));
                break;
            }
            case WARN_FIRST: {
                recorder.allowUnsafeMultipleLastResources(capabilities.isPresent("io.quarkus.agroal"), true);
                logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("com.arjuna.ats.arjuna", new String[]{"ARJUNA012139", "ARJUNA012142"}));
                break;
            }
            case WARN_EACH: {
                recorder.allowUnsafeMultipleLastResources(capabilities.isPresent("io.quarkus.agroal"), false);
                logCleanupFilters.produce((BuildItem)new LogCleanupFilterBuildItem("com.arjuna.ats.arjuna", new String[]{"ARJUNA012139", "ARJUNA012142"}));
                break;
            }
        }
    }
}

