/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.maven.MojoLogger;
import io.quarkus.maven.QuarkusBootstrapProvider;
import io.quarkus.maven.components.BootstrapSessionListener;
import io.quarkus.maven.components.ManifestSection;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public abstract class QuarkusBootstrapMojo
extends AbstractMojo {
    static final String CLOSE_BOOTSTRAPPED_APP = "closeBootstrappedApp";
    static final String NATIVE_PROFILE_NAME = "native";
    @Component
    protected QuarkusBootstrapProvider bootstrapProvider;
    @Component(hint="quarkus-bootstrap", role=AbstractMavenLifecycleParticipant.class)
    private BootstrapSessionListener bootstrapSessionListener;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter
    private Map<String, String> manifestEntries = new LinkedHashMap<String, String>();
    @Parameter
    private List<ManifestSection> manifestSections = new ArrayList<ManifestSection>();
    @Parameter(property="ignoredEntries")
    private String[] ignoredEntries;
    @Parameter(required=false, property="appArtifact")
    private String appArtifact;
    @Parameter(property="properties", required=false)
    private Map<String, String> properties = new HashMap<String, String>();
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    MojoExecution mojoExecution;
    @Parameter(required=false)
    String bootstrapId;
    @Parameter(property="quarkusCloseBootstrappedApp")
    private Boolean closeBootstrappedApp;
    private ArtifactKey projectId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.beforeExecute()) {
            return;
        }
        try {
            this.doExecute();
        }
        finally {
            if (this.closeBootstrappedApp != null) {
                if (this.closeBootstrappedApp.booleanValue()) {
                    this.bootstrapProvider.bootstrapper(this).close();
                }
            } else if (!this.bootstrapSessionListener.isEnabled() && !this.mavenSession().getGoals().contains("quarkus:dev")) {
                this.bootstrapProvider.bootstrapper(this).close();
            }
        }
    }

    public void setLog(Log log) {
        super.setLog(log);
        MojoLogger.delegate = log;
    }

    protected abstract boolean beforeExecute() throws MojoExecutionException, MojoFailureException;

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected String appArtifactCoords() {
        return this.appArtifact;
    }

    protected List<Dependency> forcedDependencies(LaunchMode mode) {
        return List.of();
    }

    @Deprecated(forRemoval=true)
    protected RepositorySystem repositorySystem() {
        return this.bootstrapProvider.repositorySystem();
    }

    @Deprecated(forRemoval=true)
    protected RemoteRepositoryManager remoteRepositoryManager() {
        return this.bootstrapProvider.remoteRepositoryManager();
    }

    protected RepositorySystemSession repositorySystemSession() {
        return this.repoSession;
    }

    protected List<RemoteRepository> remoteRepositories() {
        return this.repos;
    }

    protected MavenProject mavenProject() {
        return this.project;
    }

    public MavenSession mavenSession() {
        return this.session;
    }

    protected File buildDir() {
        return this.buildDir;
    }

    protected File baseDir() {
        return this.project.getBasedir();
    }

    protected String finalName() {
        return this.finalName;
    }

    protected Map<String, String> manifestEntries() {
        return this.manifestEntries;
    }

    protected List<ManifestSection> manifestSections() {
        return this.manifestSections;
    }

    protected String[] ignoredEntries() {
        return this.ignoredEntries;
    }

    protected Map<String, String> properties() {
        return this.properties;
    }

    protected String bootstrapId() {
        return this.bootstrapId == null ? this.mojoExecution.getExecutionId() : this.bootstrapId;
    }

    protected ArtifactKey projectId() {
        return this.projectId == null ? (this.projectId = QuarkusBootstrapProvider.getProjectId(this.project)) : this.projectId;
    }

    protected CuratedApplication bootstrapApplication() throws MojoExecutionException {
        return this.bootstrapApplication(LaunchMode.NORMAL);
    }

    protected CuratedApplication bootstrapApplication(LaunchMode mode) throws MojoExecutionException {
        return this.bootstrapProvider.bootstrapApplication(this, mode);
    }

    protected CuratedApplication bootstrapApplication(LaunchMode mode, Consumer<QuarkusBootstrap.Builder> builderCustomizer) throws MojoExecutionException {
        return this.bootstrapProvider.bootstrapApplication(this, mode, builderCustomizer);
    }

    protected Properties getBuildSystemProperties(boolean quarkusOnly) throws MojoExecutionException {
        return this.bootstrapProvider.bootstrapper(this).getBuildSystemProperties(this, quarkusOnly);
    }

    protected boolean setNativeEnabledIfNativeProfileEnabled() {
        if (!System.getProperties().containsKey("quarkus.native.enabled") && QuarkusBootstrapMojo.isNativeProfileEnabled(this.mavenProject())) {
            Object nativeEnabledProp = this.mavenProject().getProperties().get("quarkus.native.enabled");
            String nativeEnabled = nativeEnabledProp != null ? nativeEnabledProp.toString() : "true";
            System.setProperty("quarkus.native.enabled", nativeEnabled);
            return true;
        }
        return false;
    }

    static boolean isNativeProfileEnabled(MavenProject mavenProject) {
        Stream activeProfileIds = mavenProject.getInjectedProfileIds().values().stream().flatMap(Collection::stream);
        if (activeProfileIds.anyMatch(NATIVE_PROFILE_NAME::equalsIgnoreCase)) {
            return true;
        }
        return Optional.ofNullable(mavenProject.getParent()).map(QuarkusBootstrapMojo::isNativeProfileEnabled).orElse(false);
    }
}

