/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mailer.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.mailer.MailTemplate;
import io.quarkus.mailer.MailerName;
import io.quarkus.mailer.reactive.ReactiveMailer;
import io.quarkus.mailer.runtime.MailTemplateInstanceImpl;
import io.quarkus.mailer.runtime.MailTemplateMailerName;
import io.quarkus.qute.Location;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.runtime.LocationLiteral;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.jboss.logging.Logger;

@Singleton
public class MailTemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(MailTemplateProducer.class);
    @Any
    Instance<Template> template;

    @Produces
    MailTemplate getDefault(final InjectionPoint injectionPoint, final @Any Instance<ReactiveMailer> reactiveMailer) {
        String name;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new MailTemplate(){

            @Override
            public MailTemplate.MailTemplateInstance instance() {
                return new MailTemplateInstanceImpl(MailTemplateProducer.getReactiveMailer(injectionPoint, (Instance<ReactiveMailer>)reactiveMailer), ((Template)MailTemplateProducer.this.template.select(new Annotation[]{new LocationLiteral(name)}).get()).instance());
            }
        };
    }

    @Location(value="ignored")
    @Produces
    MailTemplate get(final InjectionPoint injectionPoint, final @Any Instance<ReactiveMailer> reactiveMailer) {
        Location path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(Location.class)) continue;
            path = (Location)qualifier;
            break;
        }
        if (path == null || path.value().isEmpty()) {
            throw new IllegalStateException("No template resource path specified");
        }
        final String name = path.value();
        return new MailTemplate(){

            @Override
            public MailTemplate.MailTemplateInstance instance() {
                return new MailTemplateInstanceImpl(MailTemplateProducer.getReactiveMailer(injectionPoint, (Instance<ReactiveMailer>)reactiveMailer), ((Template)MailTemplateProducer.this.template.select(new Annotation[]{new LocationLiteral(name)}).get()).instance());
            }
        };
    }

    static ReactiveMailer getReactiveMailer(InjectionPoint injectionPoint, Instance<ReactiveMailer> reactiveMailer) {
        MailTemplateMailerName mailerName = (MailTemplateMailerName)injectionPoint.getAnnotated().getAnnotation(MailTemplateMailerName.class);
        if (mailerName != null) {
            return (ReactiveMailer)reactiveMailer.select(new Annotation[]{MailerName.Literal.of(mailerName.value())}).get();
        }
        return (ReactiveMailer)reactiveMailer.select(new Annotation[]{Default.Literal.INSTANCE}).get();
    }

    public static MailTemplate.MailTemplateInstance getMailTemplateInstance(TemplateInstance instance) {
        ReactiveMailer reactiveMailer = (ReactiveMailer)Arc.container().instance(ReactiveMailer.class, new Annotation[0]).get();
        return new MailTemplateInstanceImpl(reactiveMailer, instance);
    }
}

