/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.deployment.devui;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.liquibase.runtime.devui.LiquibaseJsonRpcService;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import liquibase.changelog.DatabaseChangeLog;

public class LiquibaseDevUIProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    void createCard(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer) {
        CardPageBuildItem card = new CardPageBuildItem();
        card.setCustomCard("qwc-liquibase-card.js");
        card.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Version").icon("font-awesome-solid:book")).url("https://www.liquibase.org/").doNotEmbed().staticLabel(LiquibaseDevUIProcessor.getManifest(DatabaseChangeLog.class).getMainAttributes().getValue("Bundle-Version")));
        card.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().title("Datasources")).componentLink("qwc-liquibase-datasources.js").icon("font-awesome-solid:database")).dynamicLabelJsonRPCMethodName("getDatasourceCount"));
        cardPageBuildItemBuildProducer.produce((BuildItem)card);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem registerJsonRpcBackend() {
        return new JsonRPCProvidersBuildItem(LiquibaseJsonRpcService.class);
    }

    private static Manifest getManifest(Class<?> clz) {
        Manifest manifest;
        block8: {
            String resource = "/" + clz.getName().replace(".", "/") + ".class";
            String fullPath = clz.getResource(resource).toString();
            String archivePath = fullPath.substring(0, fullPath.length() - resource.length());
            InputStream input = new URL(archivePath + "/META-INF/MANIFEST.MF").openStream();
            try {
                manifest = new Manifest(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Loading MANIFEST for class " + clz + " failed!", e);
                }
            }
            input.close();
        }
        return manifest;
    }
}

