/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jsonb;

import io.quarkus.arc.All;
import io.quarkus.arc.DefaultBean;
import io.quarkus.jsonb.JsonbConfigCustomizer;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.util.List;

@Singleton
public class JsonbProducer {
    @Produces
    @Dependent
    @DefaultBean
    public JsonbConfig jsonbConfig(@All List<JsonbConfigCustomizer> customizers) {
        JsonbConfig jsonbConfig = new JsonbConfig();
        for (JsonbConfigCustomizer customizer : customizers) {
            customizer.customize(jsonbConfig);
        }
        return jsonbConfig;
    }

    @Produces
    @Singleton
    @DefaultBean
    public Jsonb jsonb(JsonbConfig jsonbConfig) {
        return JsonbBuilder.create((JsonbConfig)jsonbConfig);
    }
}

