/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.runtime.http.rest;

import io.quarkus.jfr.runtime.IdProducer;
import io.quarkus.jfr.runtime.http.AbstractHttpEvent;
import io.quarkus.jfr.runtime.http.rest.Recorder;
import io.quarkus.jfr.runtime.http.rest.RestEndEvent;
import io.quarkus.jfr.runtime.http.rest.RestPeriodEvent;
import io.quarkus.jfr.runtime.http.rest.RestStartEvent;

public class ServerRecorder
implements Recorder {
    private final String httpMethod;
    private final String uri;
    private final String resourceClass;
    private final String resourceMethod;
    private final String client;
    private final IdProducer idProducer;
    private RestPeriodEvent durationEvent;

    public ServerRecorder(String httpMethod, String uri, String resourceClass, String resourceMethod, String client, IdProducer idProducer) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.resourceClass = resourceClass;
        this.resourceMethod = resourceMethod;
        this.client = client;
        this.idProducer = idProducer;
    }

    @Override
    public void recordStartEvent() {
        RestStartEvent startEvent = new RestStartEvent();
        if (startEvent.shouldCommit()) {
            this.setHttpInfo(startEvent);
            startEvent.commit();
        }
    }

    @Override
    public void recordEndEvent() {
        RestEndEvent endEvent = new RestEndEvent();
        if (endEvent.shouldCommit()) {
            this.setHttpInfo(endEvent);
            endEvent.commit();
        }
    }

    @Override
    public void startPeriodEvent() {
        this.durationEvent = new RestPeriodEvent();
        this.durationEvent.begin();
    }

    @Override
    public void endPeriodEvent() {
        this.durationEvent.end();
        if (this.durationEvent.shouldCommit()) {
            this.setHttpInfo(this.durationEvent);
            this.durationEvent.commit();
        }
    }

    private void setHttpInfo(AbstractHttpEvent event) {
        event.setTraceId(this.idProducer.getTraceId());
        event.setSpanId(this.idProducer.getSpanId());
        event.setHttpMethod(this.httpMethod);
        event.setUri(this.uri);
        event.setResourceClass(this.resourceClass);
        event.setResourceMethod(this.resourceMethod);
        event.setClient(this.client);
    }
}

