/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.runtime.http.rest;

import io.quarkus.jfr.runtime.IdProducer;
import io.quarkus.jfr.runtime.http.rest.Recorder;
import io.quarkus.jfr.runtime.http.rest.ServerRecorder;
import io.vertx.core.http.HttpServerRequest;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;

@Dependent
public class ReactiveServerRecorderProducer {
    @Context
    HttpServerRequest vertxRequest;
    @Context
    SimpleResourceInfo resourceInfo;
    @Inject
    IdProducer idProducer;

    @Produces
    @RequestScoped
    public Recorder create() {
        String httpMethod = this.vertxRequest.method().name();
        String uri = this.vertxRequest.path();
        Class resourceClass = this.resourceInfo.getResourceClass();
        String resourceClassName = resourceClass == null ? null : resourceClass.getName();
        String resourceMethodName = this.resourceInfo.getMethodName();
        String client = this.vertxRequest.remoteAddress().toString();
        return new ServerRecorder(httpMethod, uri, resourceClassName, resourceMethodName, client, this.idProducer);
    }
}

