/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.infinispan.client.InfinispanClientName;
import io.quarkus.infinispan.client.runtime.InfinispanClientRuntimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientsRuntimeConfig;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Tuple2;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;
import org.infinispan.client.hotrod.RemoteCacheManager;

@Readiness
@ApplicationScoped
public class InfinispanHealthCheck
implements HealthCheck {
    private final List<InfinispanClientCheck> checks = new ArrayList<InfinispanClientCheck>();

    @Inject
    public InfinispanHealthCheck(InfinispanClientsRuntimeConfig config) {
        this.configure(config);
    }

    public void configure(InfinispanClientsRuntimeConfig config) {
        RemoteCacheManager client;
        final Iterable handle = Arc.container().select(RemoteCacheManager.class, new Annotation[]{Any.Literal.INSTANCE}).handles();
        if (config.defaultInfinispanClient() != null && (client = this.getClient(handle, null)) != null) {
            this.checks.add(new InfinispanClientCheck("<default>", client, config.defaultInfinispanClient()));
        }
        config.namedInfinispanClients().entrySet().forEach(new Consumer<Map.Entry<String, InfinispanClientRuntimeConfig>>(){

            @Override
            public void accept(Map.Entry<String, InfinispanClientRuntimeConfig> namedInfinispanClientConfig) {
                RemoteCacheManager client = InfinispanHealthCheck.this.getClient(handle, namedInfinispanClientConfig.getKey());
                if (client != null) {
                    InfinispanHealthCheck.this.checks.add(new InfinispanClientCheck(namedInfinispanClientConfig.getKey(), client, namedInfinispanClientConfig.getValue()));
                }
            }
        });
    }

    private BiFunction<HealthInfo, Throwable, Tuple2<String, HealthInfo>> toResult(final String name) {
        return new BiFunction<HealthInfo, Throwable, Tuple2<String, HealthInfo>>(){

            @Override
            public Tuple2<String, HealthInfo> apply(HealthInfo healthInfo, Throwable failure) {
                return Tuple2.of((Object)name, (Object)(failure == null ? healthInfo : new HealthInfo(failure.getMessage(), null, -1)));
            }
        };
    }

    private RemoteCacheManager getClient(Iterable<InstanceHandle<RemoteCacheManager>> handle, String name) {
        for (InstanceHandle<RemoteCacheManager> client : handle) {
            String n = this.getInfinispanClientName((Bean<?>)client.getBean());
            if (name == null && n == null) {
                return (RemoteCacheManager)client.get();
            }
            if (name == null || !name.equals(n)) continue;
            return (RemoteCacheManager)client.get();
        }
        return null;
    }

    private String getInfinispanClientName(Bean<?> bean) {
        for (Object qualifier : bean.getQualifiers()) {
            if (!(qualifier instanceof InfinispanClientName)) continue;
            return ((InfinispanClientName)qualifier).value();
        }
        return null;
    }

    public HealthCheckResponse call() {
        final HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Infinispan cluster connection health check").up();
        ArrayList<Uni<Tuple2<String, HealthInfo>>> unis = new ArrayList<Uni<Tuple2<String, HealthInfo>>>();
        for (InfinispanClientCheck clientCheck : this.checks) {
            unis.add(clientCheck.get());
        }
        if (unis.isEmpty()) {
            return builder.build();
        }
        return (HealthCheckResponse)Uni.combine().all().unis(unis).collectFailures().combinedWith(new Function<List<?>, HealthCheckResponse>(){

            @Override
            public HealthCheckResponse apply(List<?> list) {
                return InfinispanHealthCheck.this.combine(list, builder);
            }
        }).await().indefinitely();
    }

    private HealthCheckResponse combine(List<?> results, HealthCheckResponseBuilder builder) {
        for (Object result : results) {
            Tuple2 tuple = (Tuple2)result;
            if ("OK".equalsIgnoreCase(((HealthInfo)tuple.getItem2()).state)) {
                builder.up().withData((String)tuple.getItem1() + ".servers", ((HealthInfo)tuple.getItem2()).servers).withData((String)tuple.getItem1() + ".caches-size", (long)((HealthInfo)tuple.getItem2()).cachesCount);
                continue;
            }
            builder.down().withData((String)tuple.getItem1(), "reason: " + ((HealthInfo)tuple.getItem2()).state);
        }
        return builder.build();
    }

    private class InfinispanClientCheck
    implements Supplier<Uni<Tuple2<String, HealthInfo>>> {
        final String name;
        final RemoteCacheManager remoteCacheManager;
        final InfinispanClientRuntimeConfig config;

        InfinispanClientCheck(String name, RemoteCacheManager remoteCacheManager, InfinispanClientRuntimeConfig config) {
            this.name = name;
            this.remoteCacheManager = remoteCacheManager;
            this.config = config;
        }

        @Override
        public Uni<Tuple2<String, HealthInfo>> get() {
            return Uni.createFrom().item((Supplier)new Supplier<HealthInfo>(){

                @Override
                public HealthInfo get() {
                    String servers = Arrays.toString(InfinispanClientCheck.this.remoteCacheManager.getServers());
                    int cacheNamesCount = InfinispanClientCheck.this.remoteCacheManager.getCacheNames().size();
                    return new HealthInfo("OK", servers, cacheNamesCount);
                }
            }).runSubscriptionOn(Infrastructure.getDefaultExecutor()).onItemOrFailure().transform(InfinispanHealthCheck.this.toResult(this.name));
        }
    }

    private class HealthInfo {
        String state;
        String servers;
        int cachesCount;

        public HealthInfo(String state, String servers, int cachesCount) {
            this.state = state;
            this.servers = servers;
            this.cachesCount = cachesCount;
        }
    }
}

