/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.infinispan.client.runtime.Remote;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.SerializationContext;

@ApplicationScoped
public class InfinispanClientProducer {
    private static final Log log = LogFactory.getLog(InfinispanClientProducer.class);
    public static final String PROTOBUF_FILE_PREFIX = "infinispan.client.hotrod.protofile.";
    private Properties properties;
    private RemoteCacheManager cacheManager;
    @Inject
    private BeanManager beanManager;

    private void initialize() {
        log.debug((Object)"Initializing CacheManager");
        Configuration conf = this.properties == null ? new ConfigurationBuilder().build() : this.builderFromProperties(this.properties).build();
        this.cacheManager = new RemoteCacheManager(conf);
        RemoteCache protobufMetadataCache = null;
        for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
            String keyString;
            Object key = property.getKey();
            if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)property.getValue();
            if (protobufMetadataCache == null) {
                protobufMetadataCache = this.cacheManager.getCache("___protobuf_metadata");
            }
            protobufMetadataCache.put((Object)fileName, (Object)fileContents);
        }
    }

    public static void replaceProperties(Properties properties) throws ClassNotFoundException {
        String marshallerClassName = (String)properties.get("infinispan.client.hotrod.marshaller");
        if (marshallerClassName != null) {
            Class<?> marshallerClass = Class.forName(marshallerClassName);
            properties.put("infinispan.client.hotrod.marshaller", Util.getInstance(marshallerClass));
        } else {
            properties.put("infinispan.client.hotrod.marshaller", new ProtoStreamMarshaller());
        }
    }

    public static void handleProtoStreamRequirements(Properties properties) {
        properties.put("infinispan.client.hotrod.protofile./org/infinispan/query/remote/client/query.proto", InfinispanClientProducer.getContents("/org/infinispan/query/remote/client/query.proto"));
        properties.put("infinispan.client.hotrod.protofile./org/infinispan/protostream/message-wrapping.proto", InfinispanClientProducer.getContents("/org/infinispan/protostream/message-wrapping.proto"));
    }

    private static String getContents(String fileName) {
        InputStream stream = InfinispanClientProducer.class.getResourceAsStream(fileName);
        return new Scanner(stream, "UTF-8").useDelimiter("\\A").next();
    }

    private ConfigurationBuilder builderFromProperties(Properties properties) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Object marshallerInstance = properties.remove("infinispan.client.hotrod.marshaller");
        if (marshallerInstance != null) {
            if (marshallerInstance instanceof ProtoStreamMarshaller) {
                InfinispanClientProducer.handleProtoStreamMarshaller(marshallerInstance, properties, this.beanManager);
            }
            builder.marshaller((Marshaller)marshallerInstance);
        }
        builder.withProperties(properties);
        return builder;
    }

    private static void handleProtoStreamMarshaller(Object marshallerInstance, Properties properties, BeanManager beanManager) {
        CreationalContext ctx;
        ProtoStreamMarshaller marshaller = (ProtoStreamMarshaller)marshallerInstance;
        SerializationContext serializationContext = marshaller.getSerializationContext();
        FileDescriptorSource fileDescriptorSource = null;
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String keyString;
            Object key = property.getKey();
            if (!(key instanceof String) || !(keyString = (String)key).startsWith(PROTOBUF_FILE_PREFIX)) continue;
            String fileName = keyString.substring(PROTOBUF_FILE_PREFIX.length());
            String fileContents = (String)property.getValue();
            if (fileDescriptorSource == null) {
                fileDescriptorSource = new FileDescriptorSource();
            }
            fileDescriptorSource.addProtoFile(fileName, fileContents);
        }
        try {
            if (fileDescriptorSource != null) {
                serializationContext.registerProtoFiles(fileDescriptorSource);
            }
            Set protoFileBeans = beanManager.getBeans(FileDescriptorSource.class, new Annotation[0]);
            for (Bean bean : protoFileBeans) {
                ctx = beanManager.createCreationalContext((Contextual)bean);
                FileDescriptorSource fds = (FileDescriptorSource)beanManager.getReference(bean, FileDescriptorSource.class, ctx);
                serializationContext.registerProtoFiles(fds);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Set beans = beanManager.getBeans(MessageMarshaller.class, new Annotation[0]);
        for (Bean bean : beans) {
            ctx = beanManager.createCreationalContext((Contextual)bean);
            MessageMarshaller messageMarshaller = (MessageMarshaller)beanManager.getReference(bean, MessageMarshaller.class, ctx);
            serializationContext.registerMarshaller((BaseMarshaller)messageMarshaller);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    @Remote
    @Produces
    public <K, V> RemoteCache<K, V> getRemoteCache(InjectionPoint injectionPoint) {
        RemoteCacheManager cacheManager = this.remoteCacheManager();
        Set annotationSet = injectionPoint.getQualifiers();
        Remote remote = this.getRemoteAnnotation(annotationSet);
        if (remote != null && !remote.value().isEmpty()) {
            return cacheManager.getCache(remote.value());
        }
        return cacheManager.getCache();
    }

    @Produces
    public CounterManager counterManager() {
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)this.remoteCacheManager());
    }

    @Produces
    public synchronized RemoteCacheManager remoteCacheManager() {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        this.initialize();
        return this.cacheManager;
    }

    void configure(Properties properties) {
        this.properties = properties;
    }

    private Remote getRemoteAnnotation(Set<Annotation> annotationSet) {
        for (Annotation annotation : annotationSet) {
            if (!(annotation instanceof Remote)) continue;
            return (Remote)annotation;
        }
        return null;
    }
}

