/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import io.quarkus.launcher.RuntimeLaunchClassLoader;
import java.io.Closeable;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class QuarkusLauncher {
    public static Closeable launch(String callingClass, String quarkusApplication, String ... args) {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Path appClasses;
            String classResource = callingClass.replace(".", "/") + ".class";
            URL resource = Thread.currentThread().getContextClassLoader().getResource(classResource);
            String path = resource.getPath();
            path = path.substring(0, path.length() - classResource.length());
            URL newResource = new URL(resource.getProtocol(), resource.getHost(), resource.getPort(), path);
            URI uri = newResource.toURI();
            if ("jar".equals(uri.getScheme())) {
                JarURLConnection connection = (JarURLConnection)uri.toURL().openConnection();
                connection.setDefaultUseCaches(false);
                appClasses = Paths.get(connection.getJarFileURL().toURI());
            } else {
                appClasses = Paths.get(uri);
            }
            if (quarkusApplication != null) {
                System.setProperty("quarkus.package.main-class", quarkusApplication);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("app-classes", appClasses);
            context.put("args", args);
            RuntimeLaunchClassLoader loader = new RuntimeLaunchClassLoader(QuarkusLauncher.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> launcher = loader.loadClass("io.quarkus.bootstrap.IDELauncherImpl");
            Closeable closeable = (Closeable)launcher.getDeclaredMethod("launch", Path.class, Map.class).invoke(null, appClasses, context);
            return closeable;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            System.clearProperty("quarkus-internal.serialized-app-model.path");
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }
}

