/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.health;

import grpc.health.v1.HealthOuterClass;
import grpc.health.v1.MutinyHealthGrpc;
import io.quarkus.grpc.GrpcService;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;

@Singleton
@GrpcService
public class GrpcHealthEndpoint
extends MutinyHealthGrpc.HealthImplBase {
    @Inject
    GrpcHealthStorage healthStorage;

    public Uni<HealthOuterClass.HealthCheckResponse> check(HealthOuterClass.HealthCheckRequest request) {
        return Uni.createFrom().item((Object)this.healthStorage.statusForService(request.getService()));
    }

    public Multi<HealthOuterClass.HealthCheckResponse> watch(HealthOuterClass.HealthCheckRequest request) {
        final String service = request.getService();
        BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> broadcastProcessor = this.healthStorage.createStatusBroadcastProcessor(service);
        return Multi.createBy().concatenating().streams(new Flow.Publisher[]{Multi.createFrom().item((Supplier)new Supplier<HealthOuterClass.HealthCheckResponse>(){

            @Override
            public HealthOuterClass.HealthCheckResponse get() {
                return GrpcHealthEndpoint.this.healthStorage.statusForService(service);
            }
        }), broadcastProcessor.map((Function)new Function<HealthOuterClass.HealthCheckResponse.ServingStatus, HealthOuterClass.HealthCheckResponse>(){

            @Override
            public HealthOuterClass.HealthCheckResponse apply(HealthOuterClass.HealthCheckResponse.ServingStatus servingStatus) {
                return GrpcHealthEndpoint.this.healthStorage.resultForStatus(servingStatus);
            }
        })}).skip().repetitions();
    }
}

