/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Consumer;

public class UniOnSubscribeInvoke<T>
extends UniOperator<T, T> {
    private final Consumer<? super UniSubscription> callback;

    public UniOnSubscribeInvoke(Uni<? extends T> upstream, Consumer<? super UniSubscription> callback) {
        super(upstream);
        this.callback = callback;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnSubscribeInvokeProcessor(subscriber));
    }

    private class UniOnSubscribeInvokeProcessor
    extends UniOperatorProcessor<T, T> {
        public UniOnSubscribeInvokeProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            try {
                UniOnSubscribeInvoke.this.callback.accept(subscription);
            }
            catch (Throwable e) {
                subscription.cancel();
                this.downstream.onSubscribe(EmptyUniSubscription.DONE);
                this.downstream.onFailure(e);
                return;
            }
            super.onSubscribe(subscription);
        }
    }
}

