/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.query;

import io.quarkus.arc.impl.Reflections;
import io.quarkus.funqy.runtime.query.BaseObjectReader;
import io.quarkus.funqy.runtime.query.QueryObjectMapper;
import io.quarkus.funqy.runtime.query.QueryPropertySetter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class BaseCollectionReader
extends BaseObjectReader
implements BaseObjectReader.ValueSetter {
    protected Function<String, Object> valueExtractor;
    protected QueryPropertySetter setter;

    public BaseCollectionReader(Type genericType, QueryObjectMapper mapper) {
        if (genericType == null) {
            this.valueExtractor = mapper.extractor(String.class);
            return;
        }
        if (genericType instanceof ParameterizedType) {
            Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (valueType != null) {
                Class rawType = Reflections.getRawType((Type)valueType);
                this.valueExtractor = mapper.extractor(valueType);
                if (this.valueExtractor == null) {
                    this.setter = mapper.setterFor(rawType, valueType);
                }
            } else {
                this.valueExtractor = mapper.extractor(String.class);
            }
        } else {
            Class rawType = Reflections.getRawType((Type)genericType);
            this.valueExtractor = mapper.extractor(rawType);
            if (this.valueExtractor == null) {
                this.setter = mapper.setterFor(rawType, genericType);
            }
        }
    }

    @Override
    public Function<String, Object> getExtractor() {
        return this.valueExtractor;
    }

    @Override
    public QueryPropertySetter getSetter() {
        return this.setter;
    }

    @Override
    BaseObjectReader.ValueSetter getValueSetter(String propName) {
        return this;
    }

    @Override
    public void setValue(Object target, String propName, Object value) {
        ((Collection)target).add(value);
    }

    @Override
    public void setValue(Object target, String name, String value, Map<String, List<Object>> paramToObject) {
        if (this.valueExtractor != null) {
            if (name != null) {
                return;
            }
            ((Collection)target).add(this.valueExtractor.apply(value));
        } else {
            super.setValue(target, name, value, paramToObject);
        }
    }
}

