/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.query;

import io.quarkus.funqy.runtime.query.QueryPropertySetter;
import io.quarkus.funqy.runtime.query.QueryReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class BaseObjectReader
implements QueryReader<Object>,
QueryPropertySetter {
    @Override
    public Object readValue(Iterator<Map.Entry<String, String>> params) {
        Object target = this.create();
        HashMap<String, List<Object>> paramToObject = new HashMap<String, List<Object>>();
        while (params.hasNext()) {
            Map.Entry<String, String> entry = params.next();
            String name = entry.getKey();
            String value = entry.getValue();
            this.setValue(target, name, value, paramToObject);
        }
        return target;
    }

    abstract ValueSetter getValueSetter(String var1);

    @Override
    public void setValue(Object target, String name, String value, Map<String, List<Object>> paramToObject) {
        try {
            ValueSetter setter;
            if (name == null) {
                return;
            }
            String propName = name;
            String suffix = null;
            int dot = propName.indexOf(46);
            if (dot == 0) {
                return;
            }
            if (dot > 0) {
                propName = name.substring(0, dot);
                suffix = name.substring(dot + 1);
            }
            if ((setter = this.getValueSetter(propName)) == null) {
                return;
            }
            if (suffix != null && setter.getSetter() == null) {
                return;
            }
            if (setter.getExtractor() != null) {
                Object val = setter.getExtractor().apply(value);
                setter.setValue(target, propName, val);
            } else if (setter.getSetter() != null) {
                HashMap<String, List<Object>> paramEntries;
                Object obj;
                List<Object> propEntry = paramToObject.get(propName);
                if (propEntry == null) {
                    obj = setter.getSetter().create();
                    paramEntries = new HashMap();
                    propEntry = Arrays.asList(obj, paramEntries);
                    paramToObject.put(propName, propEntry);
                    setter.setValue(target, propName, obj);
                } else {
                    obj = propEntry.get(0);
                    paramEntries = (Map)propEntry.get(1);
                }
                setter.getSetter().setValue(obj, suffix, value, paramEntries);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static interface ValueSetter {
        public void setValue(Object var1, String var2, Object var3);

        public Function<String, Object> getExtractor();

        public QueryPropertySetter getSetter();
    }
}

