/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.bindings.knative.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.funqy.knative.events.AbstractCloudEvent;
import io.quarkus.funqy.knative.events.CloudEvent;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class HeaderCloudEventImpl<T>
extends AbstractCloudEvent<T>
implements CloudEvent<T> {
    String id;
    String specVersion;
    String source;
    String type;
    String subject;
    OffsetDateTime time;
    Map<String, String> extensions;
    String dataSchema;
    String dataContentType;
    T data;
    final MultiMap headers;
    final Buffer buffer;
    final Type dataType;
    final ObjectMapper mapper;
    private ObjectReader reader;
    private static final Set<String> reservedHeaders;

    HeaderCloudEventImpl(MultiMap headers, Buffer buffer, Type dataType, ObjectMapper mapper, ObjectReader reader) {
        this.headers = headers;
        this.buffer = buffer;
        this.dataType = dataType;
        this.mapper = mapper;
        this.reader = reader;
    }

    @Override
    public String id() {
        if (this.id == null) {
            this.id = this.headers.get("ce-id");
        }
        return this.id;
    }

    @Override
    public String specVersion() {
        String sv;
        if (this.specVersion == null && (sv = this.headers.get("ce-specversion")) != null) {
            this.specVersion = sv;
        }
        return this.specVersion;
    }

    @Override
    public String source() {
        if (this.source == null && this.headers.contains("ce-source")) {
            this.source = this.headers.get("ce-source");
        }
        return this.source;
    }

    @Override
    public String type() {
        if (this.type == null) {
            this.type = this.headers.get("ce-type");
        }
        return this.type;
    }

    @Override
    public String subject() {
        if (this.subject == null) {
            this.subject = this.headers.get("ce-subject");
        }
        return this.subject;
    }

    @Override
    public OffsetDateTime time() {
        String t;
        if (this.time == null && (t = this.headers.get("ce-time")) != null) {
            this.time = OffsetDateTime.parse(t);
        }
        return this.time;
    }

    private static boolean isCEHeader(String value) {
        return !(value.charAt(0) != 'C' && value.charAt(0) != 'c' || value.charAt(1) != 'E' && value.charAt(1) != 'e' || value.charAt(2) != '-');
    }

    @Override
    public Map<String, String> extensions() {
        if (this.extensions == null) {
            this.extensions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry entry : this.headers) {
                if (!HeaderCloudEventImpl.isCEHeader((String)entry.getKey()) || reservedHeaders.contains(entry.getKey())) continue;
                this.extensions.put(((String)entry.getKey()).substring(3), (String)entry.getValue());
            }
            this.extensions = Collections.unmodifiableMap(this.extensions);
        }
        return this.extensions;
    }

    @Override
    public String dataSchema() {
        if (this.dataSchema == null) {
            String dsName = this.majorSpecVersion() == 0 ? "ce-schemaurl" : "ce-dataschema";
            this.dataSchema = this.headers.get(dsName);
        }
        return this.dataSchema;
    }

    @Override
    public String dataContentType() {
        if (this.dataContentType == null) {
            this.dataContentType = this.headers.get("Content-Type");
        }
        return this.dataContentType;
    }

    @Override
    public T data() {
        if (this.data != null) {
            return this.data;
        }
        if (this.dataContentType() != null && this.dataContentType().startsWith("application/json") && !byte[].class.equals((Object)this.dataType)) {
            try {
                this.data = this.reader.readValue(this.buffer.getBytes());
                return this.data;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (byte[].class.equals((Object)this.dataType)) {
            this.data = (T)this.buffer.getBytes();
            return this.data;
        }
        String msg = String.format("Don't know how to get event data (dataContentType: '%s', javaType: '%s').", this.dataContentType(), this.dataType.getTypeName());
        throw new RuntimeException(msg);
    }

    static {
        TreeSet<String> ra = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ra.add("ce-specversion");
        ra.add("ce-id");
        ra.add("ce-source");
        ra.add("ce-type");
        ra.add("Content-Type");
        ra.add("ce-subject");
        ra.add("ce-time");
        ra.add("ce-datacontentencoding");
        ra.add("ce-schemaurl");
        ra.add("ce-dataschema");
        reservedHeaders = Collections.unmodifiableSet(ra);
    }
}

