/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.merger;

import io.quarkus.annotation.processor.Outputs;
import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.util.JacksonMappers;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;

public final class JavadocMerger {
    private JavadocMerger() {
    }

    public static JavadocRepository mergeJavadocElements(List<Path> buildOutputDirectories) {
        HashMap<String, JavadocElements.JavadocElement> javadocElementsMap = new HashMap<String, JavadocElements.JavadocElement>();
        for (Path buildOutputDirectory : buildOutputDirectories) {
            Path javadocPath = buildOutputDirectory.resolve(Outputs.QUARKUS_CONFIG_DOC_JAVADOC);
            if (!Files.isReadable(javadocPath)) continue;
            try {
                JavadocElements javadocElements = (JavadocElements)JacksonMappers.yamlObjectReader().readValue(javadocPath.toFile(), JavadocElements.class);
                if (javadocElements.elements() == null || javadocElements.elements().isEmpty()) continue;
                javadocElementsMap.putAll(javadocElements.elements());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to parse: " + javadocPath, e);
            }
        }
        return new JavadocRepository(javadocElementsMap);
    }
}

