/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.generate_doc.ConfigDocBuilder;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.JavaDocParser;
import java.util.ArrayList;
import java.util.List;

public final class MavenConfigDocBuilder
extends ConfigDocBuilder {
    private final JavaDocParser javaDocParser = new JavaDocParser();

    public MavenConfigDocBuilder() {
        super(false);
    }

    public void addTableTitle(String goalTitle) {
        this.write("= ", goalTitle, "\n");
    }

    public void addNewLine() {
        this.write("\n");
    }

    public void addTableDescription(String goalDescription) {
        this.write("\n", this.javaDocParser.parseConfigDescription(goalDescription), "\n");
    }

    public GoalParamsBuilder newGoalParamsBuilder() {
        return new GoalParamsBuilder(this.javaDocParser);
    }

    public static final class GoalParamsBuilder
    extends TableBuilder {
        private final JavaDocParser javaDocParser;

        private GoalParamsBuilder(JavaDocParser javaDocParser) {
            this.javaDocParser = javaDocParser;
        }

        public void addParam(String type, String name, String defaultValue, boolean required, String description) {
            ConfigDocKey configDocKey = new ConfigDocKey();
            configDocKey.setType(type);
            configDocKey.setKey(name);
            configDocKey.setAdditionalKeys(List.of(name));
            configDocKey.setConfigPhase(ConfigPhase.RUN_TIME);
            configDocKey.setDefaultValue(defaultValue == null ? "" : defaultValue);
            this.javaDocParser.parseConfigDescription(description, configDocKey::setConfigDoc, configDocKey::setSince);
            configDocKey.setEnvironmentVariable(DocGeneratorUtil.toEnvVarName(name));
            configDocKey.setOptional(!required);
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocKey(configDocKey);
            this.configDocItems.add(configDocItem);
        }

        @Override
        protected String getSectionName() {
            return "Parameter";
        }
    }

    private static abstract class TableBuilder {
        protected final List<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();

        private TableBuilder() {
        }

        protected abstract String getSectionName();

        public List<ConfigDocItem> build() {
            ConfigDocSection parameterSection = new ConfigDocSection();
            parameterSection.setShowSection(true);
            parameterSection.setName(this.getSectionName());
            parameterSection.setSectionDetailsTitle(this.getSectionName());
            parameterSection.setOptional(false);
            parameterSection.setConfigDocItems(List.copyOf(this.configDocItems));
            ConfigDocItem topConfigDocItem = new ConfigDocItem();
            topConfigDocItem.setConfigDocSection(parameterSection);
            return List.of(topConfigDocItem);
        }

        public boolean tableIsNotEmpty() {
            return !this.configDocItems.isEmpty();
        }
    }
}

