/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.type.DeclaredType;

public class DocGeneratorUtil {
    private static String CONFIG_GROUP_PREFIX = "config-group-";
    static final String VERTX_JAVA_DOC_SITE = "https://vertx.io/docs/apidocs/";
    static final String OFFICIAL_JAVA_DOC_BASE_LINK = "https://docs.oracle.com/javase/8/docs/api/";
    static final String AGROAL_API_JAVA_DOC_SITE = "https://jar-download.com/javaDoc/io.agroal/agroal-api/1.5/index.html?";
    private static final Map<String, String> JAVA_PRIMITIVE_WRAPPERS = new HashMap<String, String>();
    private static final Map<String, String> PRIMITIVE_DEFAULT_VALUES = new HashMap<String, String>();
    private static final Map<String, String> EXTENSION_JAVA_DOC_LINK = new HashMap<String, String>();
    private static Pattern PACKAGE_PATTERN = Pattern.compile("^(\\w+)\\.(\\w+)\\..*$");

    static String getPrimitiveDefaultValue(String primitiveType) {
        return PRIMITIVE_DEFAULT_VALUES.get(primitiveType);
    }

    static String unbox(String type) {
        String mapping = JAVA_PRIMITIVE_WRAPPERS.get(type);
        return mapping == null ? type : mapping;
    }

    static String getJavaDocSiteLink(String type) {
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(type);
        if (!packageMatcher.find()) {
            return "";
        }
        if (JAVA_PRIMITIVE_WRAPPERS.containsKey(type)) {
            return "";
        }
        if ("java".equals(packageMatcher.group(1))) {
            return OFFICIAL_JAVA_DOC_BASE_LINK + DocGeneratorUtil.getJavaDocLinkForType(type);
        }
        String basePkgName = packageMatcher.group(1) + "." + packageMatcher.group(2) + ".";
        String javaDocBaseUrl = EXTENSION_JAVA_DOC_LINK.get(basePkgName);
        if (javaDocBaseUrl != null) {
            return javaDocBaseUrl + DocGeneratorUtil.getJavaDocLinkForType(type);
        }
        return "";
    }

    private static String getJavaDocLinkForType(String type) {
        int indexOfFirstUpperCase = 0;
        for (int index = 0; index < type.length(); ++index) {
            char charAt = type.charAt(index);
            if (charAt < 'A' || charAt > 'Z') continue;
            indexOfFirstUpperCase = index;
            break;
        }
        String base = type.substring(0, indexOfFirstUpperCase).replace('.', '/');
        String html = type.substring(indexOfFirstUpperCase).replace('$', '.') + ".html";
        return base + html;
    }

    static String getKnownGenericType(DeclaredType declaredType) {
        return Constants.ALIASED_TYPES.get(declaredType.toString());
    }

    static Iterator<String> camelHumpsIterator(final String str) {
        return new Iterator<String>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < str.length();
            }

            @Override
            public String next() {
                if (this.idx == str.length()) {
                    throw new NoSuchElementException();
                }
                if (str.startsWith("JBoss", this.idx)) {
                    this.idx += 5;
                    return "JBoss";
                }
                int start = this.idx;
                int c = str.codePointAt(this.idx);
                if (Character.isUpperCase(c)) {
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                    if (this.idx < str.length()) {
                        c = str.codePointAt(this.idx);
                        if (Character.isUpperCase(c)) {
                            int nextIdx = str.offsetByCodePoints(this.idx, 1);
                            while (nextIdx < str.length()) {
                                c = str.codePointAt(nextIdx);
                                if (Character.isLowerCase(c)) {
                                    return str.substring(start, this.idx);
                                }
                                this.idx = nextIdx;
                                nextIdx = str.offsetByCodePoints(this.idx, 1);
                            }
                            this.idx = str.length();
                            return str.substring(start);
                        }
                        this.idx = str.offsetByCodePoints(this.idx, 1);
                        while (this.idx < str.length()) {
                            c = str.codePointAt(this.idx);
                            if (Character.isUpperCase(c)) {
                                return str.substring(start, this.idx);
                            }
                            this.idx = str.offsetByCodePoints(this.idx, 1);
                        }
                        return str.substring(start);
                    }
                    return str.substring(start);
                }
                this.idx = str.offsetByCodePoints(this.idx, 1);
                while (this.idx < str.length()) {
                    c = str.codePointAt(this.idx);
                    if (Character.isUpperCase(c)) {
                        return str.substring(start, this.idx);
                    }
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                }
                return str.substring(start);
            }
        };
    }

    static Iterator<String> lowerCase(final Iterator<String> orig) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return orig.hasNext();
            }

            @Override
            public String next() {
                return ((String)orig.next()).toLowerCase(Locale.ROOT);
            }
        };
    }

    static String join(String delim, Iterator<String> it) {
        StringBuilder b = new StringBuilder();
        if (it.hasNext()) {
            b.append(it.next());
            while (it.hasNext()) {
                b.append(delim);
                b.append(it.next());
            }
        }
        return b.toString();
    }

    static String hyphenate(String orig) {
        return DocGeneratorUtil.join("-", DocGeneratorUtil.lowerCase(DocGeneratorUtil.camelHumpsIterator(orig)));
    }

    static String hyphenateEnumValue(String orig) {
        return orig.replace('_', '-').toLowerCase(Locale.ROOT);
    }

    static String joinAcceptedValues(List<String> acceptedValues) {
        if (acceptedValues == null || acceptedValues.isEmpty()) {
            return "";
        }
        return acceptedValues.stream().collect(Collectors.joining("`, `", "`", "`"));
    }

    static String getTypeFormatInformationNote(ConfigDocKey configDocKey) {
        if (configDocKey.getType().equals(Duration.class.getName())) {
            return Constants.DURATION_INFORMATION;
        }
        if (configDocKey.getType().equals("io.quarkus.runtime.configuration.MemorySize")) {
            return Constants.MEMORY_SIZE_INFORMATION;
        }
        return "";
    }

    static boolean hasDurationInformationNote(ConfigDocKey configDocKey) {
        return configDocKey.hasType() && configDocKey.getType().equals(Duration.class.getName());
    }

    static boolean hasMemoryInformationNote(ConfigDocKey configDocKey) {
        return configDocKey.hasType() && configDocKey.getType().equals("io.quarkus.runtime.configuration.MemorySize");
    }

    public static String computeExtensionDocFileName(String configRoot) {
        StringBuilder extensionNameBuilder = new StringBuilder();
        Matcher matcher = Constants.PKG_PATTERN.matcher(configRoot);
        if (!matcher.find()) {
            extensionNameBuilder.append(configRoot);
        } else {
            String extensionName = matcher.group(1);
            String subgroup = matcher.group(2);
            extensionNameBuilder.append("quarkus");
            extensionNameBuilder.append("-");
            if ("deployment".equals(extensionName) || "runtime".equals(extensionName)) {
                String configClass = configRoot.substring(configRoot.lastIndexOf(46) + 1);
                extensionName = DocGeneratorUtil.hyphenate(configClass);
                extensionNameBuilder.append("core-");
                extensionNameBuilder.append(extensionName);
            } else if (subgroup != null && !"deployment".equals(subgroup) && !"runtime".equals(subgroup) && !"common".equals(subgroup) && subgroup.matches("^[a-z0-9]+$")) {
                extensionNameBuilder.append(extensionName);
                extensionNameBuilder.append("-");
                extensionNameBuilder.append(subgroup);
                String qualifier = matcher.group(3);
                if (qualifier != null && !"deployment".equals(qualifier) && !"runtime".equals(qualifier) && !"common".equals(qualifier) && qualifier.matches("^[a-z0-9]+$")) {
                    extensionNameBuilder.append("-");
                    extensionNameBuilder.append(qualifier);
                }
            } else {
                extensionNameBuilder.append(extensionName);
            }
        }
        extensionNameBuilder.append(".adoc");
        return extensionNameBuilder.toString();
    }

    public static String computeConfigGroupDocFileName(String configGroup) {
        Matcher matcher = Constants.PKG_PATTERN.matcher(configGroup);
        if (!matcher.find()) {
            return CONFIG_GROUP_PREFIX + DocGeneratorUtil.hyphenate(configGroup) + ".adoc";
        }
        String replacement = "-" + CONFIG_GROUP_PREFIX;
        String sanitizedClassName = configGroup.replaceFirst("io.", "").replaceFirst("\\.runtime\\.", replacement).replaceFirst("\\.deployment\\.", replacement);
        return DocGeneratorUtil.hyphenate(sanitizedClassName).replaceAll("[\\.-]+", "-") + ".adoc";
    }

    public static void appendConfigItemsIntoExistingOnes(List<ConfigDocItem> existingConfigItems, List<ConfigDocItem> configDocItems) {
        for (ConfigDocItem configDocItem : configDocItems) {
            if (configDocItem.isConfigKey()) {
                existingConfigItems.add(configDocItem);
                continue;
            }
            ConfigDocSection configDocSection = configDocItem.getConfigDocSection();
            boolean configSectionMerged = DocGeneratorUtil.mergeSectionIntoPreviousExistingConfigItems(configDocSection, existingConfigItems);
            if (configSectionMerged) continue;
            existingConfigItems.add(configDocItem);
        }
    }

    private static boolean mergeSectionIntoPreviousExistingConfigItems(ConfigDocSection section, List<ConfigDocItem> configDocItems) {
        for (ConfigDocItem configDocItem : configDocItems) {
            if (configDocItem.isConfigKey()) continue;
            ConfigDocSection configDocSection = configDocItem.getConfigDocSection();
            if (configDocSection.equals(section)) {
                configDocSection.addConfigDocItems(section.getConfigDocItems());
                return true;
            }
            boolean configSectionMerged = DocGeneratorUtil.mergeSectionIntoPreviousExistingConfigItems(section, configDocSection.getConfigDocItems());
            if (!configSectionMerged) continue;
            return true;
        }
        return false;
    }

    static {
        PRIMITIVE_DEFAULT_VALUES.put("int", "0");
        PRIMITIVE_DEFAULT_VALUES.put("byte", "0");
        PRIMITIVE_DEFAULT_VALUES.put("char", "");
        PRIMITIVE_DEFAULT_VALUES.put("short", "0");
        PRIMITIVE_DEFAULT_VALUES.put("long", "0l");
        PRIMITIVE_DEFAULT_VALUES.put("float", "0f");
        PRIMITIVE_DEFAULT_VALUES.put("double", "0d");
        PRIMITIVE_DEFAULT_VALUES.put("boolean", "false");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Character", "char");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Boolean", "boolean");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Byte", "byte");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Short", "short");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Integer", "int");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Long", "long");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Float", "float");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Double", "double");
        EXTENSION_JAVA_DOC_LINK.put("io.vertx.", VERTX_JAVA_DOC_SITE);
        EXTENSION_JAVA_DOC_LINK.put("io.agroal.", AGROAL_API_JAVA_DOC_SITE);
    }
}

