/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.generate_doc.ConfigDocElement;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.DocFormatter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class ConfigDocSection
implements ConfigDocElement,
Comparable<ConfigDocElement> {
    private String name;
    private boolean withinAMap;
    private String sectionDetails;
    private String sectionDetailsTitle;
    private ConfigPhase configPhase;
    private List<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();
    private String anchorPrefix;

    @Override
    public boolean isWithinAMap() {
        return this.withinAMap;
    }

    public void setWithinAMap(boolean withinAMap) {
        this.withinAMap = withinAMap;
    }

    @Override
    public ConfigPhase getConfigPhase() {
        return this.configPhase;
    }

    public void setConfigPhase(ConfigPhase configPhase) {
        this.configPhase = configPhase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSectionDetails() {
        return this.sectionDetails;
    }

    public void setSectionDetails(String sectionDetails) {
        this.sectionDetails = sectionDetails;
    }

    public String getSectionDetailsTitle() {
        return this.sectionDetailsTitle;
    }

    public void setSectionDetailsTitle(String sectionDetailsTitle) {
        this.sectionDetailsTitle = sectionDetailsTitle;
    }

    public List<ConfigDocItem> getConfigDocItems() {
        return this.configDocItems;
    }

    public void setConfigDocItems(List<ConfigDocItem> configDocItems) {
        this.configDocItems = configDocItems;
    }

    public void addConfigDocItems(List<ConfigDocItem> configDocItems) {
        this.configDocItems.addAll(configDocItems);
    }

    @Override
    public void accept(Writer writer, DocFormatter docFormatter) throws IOException {
        docFormatter.format(writer, this);
    }

    @Override
    public int compareTo(ConfigDocElement o) {
        return this.compare(o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigDocSection that = (ConfigDocSection)o;
        return this.sectionDetailsTitle.equals(that.sectionDetailsTitle);
    }

    public int hashCode() {
        return Objects.hash(this.sectionDetailsTitle);
    }

    public String toString() {
        return "ConfigDocSection{name='" + this.name + '\'' + ", withinAMap=" + this.withinAMap + ", sectionDetails='" + this.sectionDetails + '\'' + ", sectionDetailsTitle='" + this.sectionDetailsTitle + '\'' + ", configPhase=" + this.configPhase + ", configDocItems=" + this.configDocItems + ", anchorPrefix=" + this.anchorPrefix + '}';
    }

    public boolean hasDurationInformationNote() {
        for (ConfigDocItem item : this.configDocItems) {
            if (!item.hasDurationInformationNote()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMemoryInformationNote() {
        for (ConfigDocItem item : this.configDocItems) {
            if (!item.hasMemoryInformationNote()) continue;
            return true;
        }
        return false;
    }

    public void setAnchorPrefix(String anchorPrefix) {
        this.anchorPrefix = anchorPrefix;
    }

    public String getAnchorPrefix() {
        return this.anchorPrefix;
    }
}

