/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.JavaDocParser;
import io.quarkus.annotation.processor.generate_doc.ScannedConfigDocsItemHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class ConfigDoItemFinder {
    private static final String NAMED_MAP_CONFIG_ITEM_FORMAT = ".\"%s\"";
    private final JavaDocParser javaDocParser = new JavaDocParser();
    private final ScannedConfigDocsItemHolder holder = new ScannedConfigDocsItemHolder();
    private final Set<ConfigRootInfo> configRoots;
    private final Map<String, TypeElement> configGroups;
    private final Properties javaDocProperties;

    public ConfigDoItemFinder(Set<ConfigRootInfo> configRoots, Map<String, TypeElement> configGroups, Properties javaDocProperties) {
        this.configRoots = configRoots;
        this.configGroups = configGroups;
        this.javaDocProperties = javaDocProperties;
    }

    ScannedConfigDocsItemHolder findInMemoryConfigurationItems() {
        for (ConfigRootInfo configRootInfo : this.configRoots) {
            TypeElement element = configRootInfo.getClazz();
            int sectionLevel = 2;
            List<ConfigDocItem> configDocItems = this.recursivelyFindConfigItems(element, configRootInfo.getName(), configRootInfo.getConfigPhase(), false, 2);
            this.holder.addToAllConfigItems(configRootInfo.getClazz().getQualifiedName().toString(), configDocItems);
        }
        return this.holder;
    }

    private List<ConfigDocItem> recursivelyFindConfigItems(Element element, String parentName, ConfigPhase configPhase, boolean withinAMap, int sectionLevel) {
        ArrayList<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();
        for (Element element2 : element.getEnclosedElements()) {
            boolean bl;
            String hyphenatedFieldName;
            boolean isStaticField;
            if (!element2.getKind().isField() || (isStaticField = element2.getModifiers().stream().anyMatch(Modifier.STATIC::equals))) continue;
            String name = "";
            String defaultValue = "<<no default>>";
            String defaultValueDoc = "";
            TypeMirror typeMirror = element2.asType();
            String type = typeMirror.toString();
            List<String> acceptedValues = null;
            Element configGroup = this.configGroups.get(type);
            ConfigDocSection configSection = null;
            boolean isConfigGroup = configGroup != null;
            TypeElement clazz = (TypeElement)element;
            String fieldName = element2.getSimpleName().toString();
            String javaDocKey = clazz.getQualifiedName().toString() + '.' + fieldName;
            List<? extends AnnotationMirror> annotationMirrors = element2.getAnnotationMirrors();
            String rawJavaDoc = this.javaDocProperties.getProperty(javaDocKey);
            String configDocMapKey = hyphenatedFieldName = DocGeneratorUtil.hyphenate(fieldName);
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String annotationName = annotationMirror.getAnnotationType().toString();
                if (annotationName.equals("io.quarkus.runtime.annotations.ConfigItem") || annotationName.equals("io.quarkus.runtime.annotations.ConfigDocMapKey")) {
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        String key = entry.getKey().toString();
                        String value = entry.getValue().getValue().toString();
                        if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocMapKey") && "value()".equals(key)) {
                            configDocMapKey = value;
                            continue;
                        }
                        if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigItem")) continue;
                        if ("name()".equals(key)) {
                            switch (value) {
                                case "<<hyphenated element name>>": {
                                    name = parentName + '.' + hyphenatedFieldName;
                                    break;
                                }
                                case "<<parent>>": {
                                    name = parentName;
                                    break;
                                }
                                default: {
                                    name = parentName + '.' + value;
                                    break;
                                }
                            }
                            continue;
                        }
                        if ("defaultValue()".equals(key)) {
                            defaultValue = value;
                            continue;
                        }
                        if (!"defaultValueDocumentation()".equals(key)) continue;
                        defaultValueDoc = value;
                    }
                    continue;
                }
                if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigDocSection")) continue;
                JavaDocParser.SectionHolder sectionHolder = this.javaDocParser.parseConfigSection(rawJavaDoc, sectionLevel);
                configSection = new ConfigDocSection();
                configSection.setWithinAMap(withinAMap);
                configSection.setConfigPhase(configPhase);
                configSection.setSectionDetails(sectionHolder.details);
                configSection.setSectionDetailsTitle(sectionHolder.title);
                configSection.setName(parentName + '.' + hyphenatedFieldName);
            }
            if (name.isEmpty()) {
                name = parentName + '.' + hyphenatedFieldName;
            }
            if ("<<no default>>".equals(defaultValue)) {
                defaultValue = "";
            }
            if ("".equals(defaultValue)) {
                defaultValue = defaultValueDoc;
            }
            if (isConfigGroup) {
                List<ConfigDocItem> groupConfigItems = this.recordConfigItemsFromConfigGroup(configPhase, name, configGroup, configSection, withinAMap, sectionLevel);
                configDocItems.addAll(groupConfigItems);
                continue;
            }
            ConfigDocKey configDocKey = new ConfigDocKey();
            configDocKey.setWithinAMap(withinAMap);
            boolean bl2 = false;
            boolean list = false;
            if (!typeMirror.getKind().isPrimitive()) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                Name qualifiedName = typeElement.getQualifiedName();
                bl = qualifiedName.toString().startsWith("java.util.Optional");
                list = qualifiedName.contentEquals("java.util.List");
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    if (typeArguments.size() == 2) {
                        String mapKey = String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, configDocMapKey);
                        type = typeArguments.get(1).toString();
                        configGroup = this.configGroups.get(type);
                        name = name + mapKey;
                        if (configGroup != null) {
                            name = name + String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, configDocMapKey);
                            List<ConfigDocItem> groupConfigItems = this.recordConfigItemsFromConfigGroup(configPhase, name, configGroup, configSection, true, sectionLevel);
                            configDocItems.addAll(groupConfigItems);
                            continue;
                        }
                        configDocKey.setWithinAMap(true);
                    } else {
                        TypeMirror realTypeMirror = typeArguments.get(0);
                        type = this.simpleTypeToString(realTypeMirror);
                        if (this.isEnumType(realTypeMirror)) {
                            acceptedValues = this.extractEnumValues(realTypeMirror);
                        }
                    }
                } else {
                    type = this.simpleTypeToString(declaredType);
                    if (this.isEnumType(declaredType)) {
                        acceptedValues = this.extractEnumValues(declaredType);
                    }
                }
            }
            String configDescription = this.javaDocParser.parseConfigDescription(rawJavaDoc);
            configDocKey.setKey(name);
            configDocKey.setType(type);
            configDocKey.setConfigPhase(configPhase);
            configDocKey.setDefaultValue(defaultValue);
            configDocKey.setOptional(bl);
            configDocKey.setList(list);
            configDocKey.setConfigDoc(configDescription);
            configDocKey.setAcceptedValues(acceptedValues);
            configDocKey.setJavaDocSiteLink(DocGeneratorUtil.getJavaDocSiteLink(type));
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocKey(configDocKey);
            configDocItems.add(configDocItem);
        }
        return configDocItems;
    }

    private List<ConfigDocItem> recordConfigItemsFromConfigGroup(ConfigPhase configPhase, String name, Element configGroup, ConfigDocSection configSection, boolean withinAMap, int sectionLevel) {
        List<ConfigDocItem> groupConfigItems;
        ArrayList<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();
        if (configSection != null) {
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocSection(configSection);
            configDocItems.add(configDocItem);
            groupConfigItems = this.recursivelyFindConfigItems(configGroup, name, configPhase, withinAMap, sectionLevel + 1);
            configSection.addConfigDocItems(groupConfigItems);
        } else {
            groupConfigItems = this.recursivelyFindConfigItems(configGroup, name, configPhase, withinAMap, sectionLevel);
            configDocItems.addAll(groupConfigItems);
        }
        String configGroupName = configGroup.asType().toString();
        List<ConfigDocItem> previousConfigGroupConfigItems = this.holder.getConfigGroupConfigItems().get(configGroupName);
        if (previousConfigGroupConfigItems == null) {
            this.holder.addConfigGroupItems(configGroupName, groupConfigItems);
        } else {
            previousConfigGroupConfigItems.addAll(configDocItems);
        }
        return configDocItems;
    }

    private String simpleTypeToString(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror.toString();
        }
        String knownGenericType = DocGeneratorUtil.getKnownGenericType((DeclaredType)typeMirror);
        return knownGenericType != null ? knownGenericType : typeMirror.toString();
    }

    private List<String> extractEnumValues(TypeMirror realTypeMirror) {
        Element declaredTypeElement = ((DeclaredType)realTypeMirror).asElement();
        ArrayList<String> acceptedValues = new ArrayList<String>();
        for (Element element : declaredTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            acceptedValues.add(DocGeneratorUtil.hyphenateEnumValue(element.getSimpleName().toString()));
        }
        return acceptedValues;
    }

    private boolean isEnumType(TypeMirror realTypeMirror) {
        return realTypeMirror instanceof DeclaredType && ((DeclaredType)realTypeMirror).asElement().getKind() == ElementKind.ENUM;
    }
}

