/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import io.quarkus.annotation.processor.generate_doc.JavaDocParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public final class ConfigDocItemScanner {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String NAMED_MAP_CONFIG_ITEM_FORMAT = ".\"%s\"";
    private static final String IO_QUARKUS_TEST_EXTENSION_PACKAGE = "io.quarkus.extest.";
    private final JavaDocParser javaDocParser = new JavaDocParser();
    private final Set<ConfigRootInfo> configRoots = new HashSet<ConfigRootInfo>();
    private final Set<String> processorClassMembers = new HashSet<String>();
    private final Map<String, TypeElement> configGroups = new HashMap<String, TypeElement>();

    public void addProcessorClassMember(String member) {
        this.processorClassMembers.add(member);
    }

    public void addConfigGroups(TypeElement configGroup) {
        String configGroupName = configGroup.getQualifiedName().toString();
        Matcher pkgMatcher = Constants.PKG_PATTERN.matcher(configGroupName);
        if (!pkgMatcher.find() || configGroupName.startsWith(IO_QUARKUS_TEST_EXTENSION_PACKAGE)) {
            return;
        }
        this.configGroups.put(configGroupName, configGroup);
    }

    public void addConfigRoot(PackageElement pkg, TypeElement clazz) {
        Matcher pkgMatcher = Constants.PKG_PATTERN.matcher(pkg.toString());
        if (!pkgMatcher.find() || pkg.toString().startsWith(IO_QUARKUS_TEST_EXTENSION_PACKAGE)) {
            return;
        }
        ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            Matcher nameMatcher;
            String annotationName = annotationMirror.getAnnotationType().toString();
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigRoot")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotationMirror.getElementValues();
            String name = "";
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().getValue().toString();
                if ("name()".equals(key)) {
                    name = "quarkus." + value;
                    continue;
                }
                if (!"phase()".equals(key)) continue;
                configPhase = ConfigPhase.valueOf(value);
            }
            if (name.isEmpty() && (nameMatcher = Constants.CONFIG_ROOT_PATTERN.matcher(clazz.getSimpleName())).find()) {
                name = "quarkus." + DocGeneratorUtil.hyphenate(nameMatcher.group(1));
            }
            String extensionName = pkgMatcher.group(1);
            ConfigRootInfo configRootInfo = new ConfigRootInfo(name, clazz, extensionName, configPhase);
            this.configRoots.add(configRootInfo);
            break;
        }
    }

    public Map<String, List<ConfigDocItem>> scanExtensionsConfigurationItems(Properties javaDocProperties) throws IOException {
        Map<String, List<ConfigDocItem>> inMemoryConfigurationItems = this.findInMemoryConfigurationItems(javaDocProperties);
        if (!inMemoryConfigurationItems.isEmpty()) {
            if (!Constants.GENERATED_DOCS_DIR.exists()) {
                Constants.GENERATED_DOCS_DIR.mkdirs();
            }
            if (!Constants.ALL_CR_GENERATED_DOC.exists()) {
                Constants.ALL_CR_GENERATED_DOC.createNewFile();
            }
        }
        Properties allExtensionGeneratedDocs = new Properties();
        if (Constants.ALL_CR_GENERATED_DOC.exists()) {
            Throwable object = null;
            try (BufferedReader bufferedReader = Files.newBufferedReader(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8);){
                allExtensionGeneratedDocs.load(bufferedReader);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
        }
        if (!inMemoryConfigurationItems.isEmpty()) {
            for (Map.Entry entry : inMemoryConfigurationItems.entrySet()) {
                String serializableConfigRootDoc = OBJECT_MAPPER.writeValueAsString(entry.getValue());
                allExtensionGeneratedDocs.put(entry.getKey(), serializableConfigRootDoc);
            }
            Throwable throwable = null;
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                allExtensionGeneratedDocs.store(bufferedWriter, "");
            }
            catch (Throwable serializableConfigRootDoc) {
                Throwable throwable3 = serializableConfigRootDoc;
                throw serializableConfigRootDoc;
            }
        }
        HashMap<String, List<ConfigDocItem>> foundExtensionConfigurationItems = new HashMap<String, List<ConfigDocItem>>();
        for (String member : this.processorClassMembers) {
            String fileName;
            List previousExtensionConfigDocKeys;
            List configDocItems = inMemoryConfigurationItems.get(member);
            if (configDocItems == null) {
                String serializedContent = allExtensionGeneratedDocs.getProperty(member);
                if (serializedContent == null) continue;
                configDocItems = (List)OBJECT_MAPPER.readValue(serializedContent, (TypeReference)new TypeReference<List<ConfigDocItem>>(){});
            }
            if ((previousExtensionConfigDocKeys = (List)foundExtensionConfigurationItems.get(fileName = DocGeneratorUtil.computeExtensionDocFileName(member))) == null) {
                foundExtensionConfigurationItems.put(fileName, configDocItems);
                continue;
            }
            previousExtensionConfigDocKeys.addAll(configDocItems);
        }
        return foundExtensionConfigurationItems;
    }

    public Map<String, List<ConfigDocItem>> loadAllExtensionsConfigurationItems() throws IOException {
        if (!Constants.GENERATED_DOCS_DIR.exists()) {
            Constants.GENERATED_DOCS_DIR.mkdirs();
        }
        Properties allExtensionGeneratedDocs = new Properties();
        if (Constants.ALL_CR_GENERATED_DOC.exists()) {
            BufferedReader bufferedReader = Files.newBufferedReader(Constants.ALL_CR_GENERATED_DOC.toPath(), StandardCharsets.UTF_8);
            Object object = null;
            try {
                allExtensionGeneratedDocs.load(bufferedReader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bufferedReader != null) {
                    if (object != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
        }
        HashMap<String, List<ConfigDocItem>> foundExtensionConfigurationItems = new HashMap<String, List<ConfigDocItem>>();
        for (String string : allExtensionGeneratedDocs.keySet()) {
            String serializedContent = allExtensionGeneratedDocs.getProperty(string);
            if (serializedContent == null) continue;
            List configDocItems = (List)OBJECT_MAPPER.readValue(serializedContent, (TypeReference)new TypeReference<List<ConfigDocItem>>(){});
            foundExtensionConfigurationItems.put(string, configDocItems);
        }
        return foundExtensionConfigurationItems;
    }

    private Map<String, List<ConfigDocItem>> findInMemoryConfigurationItems(Properties javaDocProperties) {
        HashMap<String, List<ConfigDocItem>> configOutput = new HashMap<String, List<ConfigDocItem>>();
        for (ConfigRootInfo configRootInfo : this.configRoots) {
            TypeElement element = configRootInfo.getClazz();
            ArrayList<ConfigDocItem> configDocItems = new ArrayList<ConfigDocItem>();
            int sectionLevel = 2;
            this.recordConfigItems(configDocItems, element, configRootInfo.getName(), configRootInfo.getConfigPhase(), javaDocProperties, false, 2);
            configOutput.put(configRootInfo.getClazz().getQualifiedName().toString(), configDocItems);
        }
        return configOutput;
    }

    private void recordConfigItems(List<ConfigDocItem> configDocItems, Element element, String parentName, ConfigPhase configPhase, Properties javaDocProperties, boolean withinAMap, int sectionLevel) {
        for (Element element2 : element.getEnclosedElements()) {
            boolean bl;
            String hyphenatedFieldName;
            boolean isStaticField;
            if (!element2.getKind().isField() || (isStaticField = element2.getModifiers().stream().anyMatch(Modifier.STATIC::equals))) continue;
            String name = "";
            String defaultValue = "<<no default>>";
            String defaultValueDoc = "";
            TypeMirror typeMirror = element2.asType();
            String type = typeMirror.toString();
            List<String> acceptedValues = null;
            Element configGroup = this.configGroups.get(type);
            ConfigDocSection configSection = null;
            boolean isConfigGroup = configGroup != null;
            TypeElement clazz = (TypeElement)element;
            String fieldName = element2.getSimpleName().toString();
            String javaDocKey = clazz.getQualifiedName().toString() + '.' + fieldName;
            List<? extends AnnotationMirror> annotationMirrors = element2.getAnnotationMirrors();
            String rawJavaDoc = javaDocProperties.getProperty(javaDocKey);
            String configDocMapKey = hyphenatedFieldName = DocGeneratorUtil.hyphenate(fieldName);
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String annotationName = annotationMirror.getAnnotationType().toString();
                if (annotationName.equals("io.quarkus.runtime.annotations.ConfigItem") || annotationName.equals("io.quarkus.runtime.annotations.ConfigDocMapKey")) {
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        String key = entry.getKey().toString();
                        String value = entry.getValue().getValue().toString();
                        if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocMapKey") && "value()".equals(key)) {
                            configDocMapKey = value;
                            continue;
                        }
                        if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigItem")) continue;
                        if ("name()".equals(key)) {
                            switch (value) {
                                case "<<hyphenated element name>>": {
                                    name = parentName + '.' + hyphenatedFieldName;
                                    break;
                                }
                                case "<<parent>>": {
                                    name = parentName;
                                    break;
                                }
                                default: {
                                    name = parentName + '.' + value;
                                    break;
                                }
                            }
                            continue;
                        }
                        if ("defaultValue()".equals(key)) {
                            defaultValue = value;
                            continue;
                        }
                        if (!"defaultValueDocumentation()".equals(key)) continue;
                        defaultValueDoc = value;
                    }
                    continue;
                }
                if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigDocSection")) continue;
                JavaDocParser.SectionHolder sectionHolder = this.javaDocParser.parseConfigSection(rawJavaDoc, sectionLevel);
                configSection = new ConfigDocSection();
                configSection.setWithinAMap(withinAMap);
                configSection.setConfigPhase(configPhase);
                configSection.setName(parentName + '.' + hyphenatedFieldName);
                configSection.setSectionDetails(sectionHolder.details);
                configSection.setSectionDetailsTitle(sectionHolder.title);
            }
            if (name.isEmpty()) {
                name = parentName + '.' + hyphenatedFieldName;
            }
            if ("<<no default>>".equals(defaultValue)) {
                defaultValue = "";
            }
            if ("".equals(defaultValue)) {
                defaultValue = defaultValueDoc;
            }
            if (isConfigGroup) {
                this.recordSectionConfigItems(configDocItems, configPhase, javaDocProperties, name, configGroup, configSection, withinAMap, sectionLevel);
                continue;
            }
            ConfigDocKey configDocKey = new ConfigDocKey();
            configDocKey.setWithinAMap(withinAMap);
            boolean bl2 = false;
            boolean list = false;
            if (!typeMirror.getKind().isPrimitive()) {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                Name qualifiedName = typeElement.getQualifiedName();
                if (qualifiedName.contentEquals("java.util.Optional") || qualifiedName.contentEquals("java.util.OptionalInt") || qualifiedName.contentEquals("java.util.OptionalDouble") || qualifiedName.contentEquals("java.util.OptionalLong")) {
                    bl = true;
                } else if (qualifiedName.contentEquals("java.util.List")) {
                    list = true;
                }
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!typeArguments.isEmpty()) {
                    if (typeArguments.size() == 2) {
                        String mapKey = String.format(NAMED_MAP_CONFIG_ITEM_FORMAT, configDocMapKey);
                        type = typeArguments.get(1).toString();
                        configGroup = this.configGroups.get(type);
                        name = name + mapKey;
                        if (configGroup != null) {
                            this.recordSectionConfigItems(configDocItems, configPhase, javaDocProperties, name, configGroup, configSection, true, sectionLevel);
                            continue;
                        }
                        configDocKey.setWithinAMap(true);
                    } else {
                        TypeMirror realTypeMirror = typeArguments.get(0);
                        type = this.simpleTypeToString(realTypeMirror);
                        if (this.isEnumType(realTypeMirror)) {
                            acceptedValues = this.extractEnumValues(realTypeMirror);
                        }
                    }
                } else {
                    type = this.simpleTypeToString(declaredType);
                    if (this.isEnumType(declaredType)) {
                        acceptedValues = this.extractEnumValues(declaredType);
                    }
                }
            }
            String configDescription = this.javaDocParser.parseConfigDescription(rawJavaDoc);
            configDocKey.setKey(name);
            configDocKey.setType(type);
            configDocKey.setConfigPhase(configPhase);
            configDocKey.setDefaultValue(defaultValue);
            configDocKey.setOptional(bl);
            configDocKey.setList(list);
            configDocKey.setConfigDoc(configDescription);
            configDocKey.setAcceptedValues(acceptedValues);
            configDocKey.setJavaDocSiteLink(DocGeneratorUtil.getJavaDocSiteLink(type));
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocKey(configDocKey);
            configDocItems.add(configDocItem);
        }
    }

    private void recordSectionConfigItems(List<ConfigDocItem> configDocItems, ConfigPhase configPhase, Properties javaDocProperties, String name, Element configGroup, ConfigDocSection configSection, boolean withinAMap, int sectionLevel) {
        if (configSection != null) {
            ConfigDocItem configDocItem = new ConfigDocItem();
            configDocItem.setConfigDocSection(configSection);
            configDocItems.add(configDocItem);
            this.recordConfigItems(configSection.getConfigDocItems(), configGroup, name, configPhase, javaDocProperties, withinAMap, sectionLevel + 1);
        } else {
            this.recordConfigItems(configDocItems, configGroup, name, configPhase, javaDocProperties, withinAMap, sectionLevel);
        }
    }

    private String simpleTypeToString(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror.toString();
        }
        String knownGenericType = DocGeneratorUtil.getKnownGenericType((DeclaredType)typeMirror);
        return knownGenericType != null ? knownGenericType : typeMirror.toString();
    }

    private List<String> extractEnumValues(TypeMirror realTypeMirror) {
        Element declaredTypeElement = ((DeclaredType)realTypeMirror).asElement();
        ArrayList<String> acceptedValues = new ArrayList<String>();
        for (Element element : declaredTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            acceptedValues.add(DocGeneratorUtil.hyphenateEnumValue(element.getSimpleName().toString()));
        }
        return acceptedValues;
    }

    private boolean isEnumType(TypeMirror realTypeMirror) {
        return realTypeMirror instanceof DeclaredType && ((DeclaredType)realTypeMirror).asElement().getKind() == ElementKind.ENUM;
    }

    public String toString() {
        return "ConfigDocItemScanner{javaDocParser=" + this.javaDocParser + ", configRoots=" + this.configRoots + ", processorClassMembers=" + this.processorClassMembers + ", configGroups=" + this.configGroups + '}';
    }
}

