/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;

public final class ConfigItem
implements Comparable<ConfigItem> {
    private String type;
    private List<String> acceptedValues;
    private String key;
    private String configDoc;
    private boolean withinAMap;
    private String defaultValue;
    private ConfigPhase configPhase;
    private String javaDocSiteLink;

    public String toString() {
        return "ConfigItem{type='" + this.type + '\'' + ", acceptedValues=" + this.acceptedValues + ", key='" + this.key + '\'' + ", configDoc='" + this.configDoc + '\'' + ", withinAMap=" + this.withinAMap + ", defaultValue='" + this.defaultValue + '\'' + ", configPhase=" + this.configPhase + ", javaDocSiteLink='" + this.javaDocSiteLink + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigItem that = (ConfigItem)o;
        return this.withinAMap == that.withinAMap && Objects.equals(this.type, that.type) && Objects.equals(this.acceptedValues, that.acceptedValues) && Objects.equals(this.key, that.key) && Objects.equals(this.configDoc, that.configDoc) && Objects.equals(this.defaultValue, that.defaultValue) && this.configPhase == that.configPhase && Objects.equals(this.javaDocSiteLink, that.javaDocSiteLink);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.acceptedValues, this.key, this.configDoc, this.withinAMap, this.defaultValue, this.configPhase, this.javaDocSiteLink);
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasAcceptedValues() {
        return this.acceptedValues != null && !this.acceptedValues.isEmpty();
    }

    public List<String> getAcceptedValues() {
        return this.acceptedValues;
    }

    public void setAcceptedValues(List<String> acceptedValues) {
        this.acceptedValues = acceptedValues;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getConfigDoc() {
        return this.configDoc;
    }

    public void setConfigDoc(String configDoc) {
        this.configDoc = configDoc;
    }

    public String getJavaDocSiteLink() {
        if (this.javaDocSiteLink == null) {
            return "";
        }
        return this.javaDocSiteLink;
    }

    public void setJavaDocSiteLink(String javaDocSiteLink) {
        this.javaDocSiteLink = javaDocSiteLink;
    }

    public String getDefaultValue() {
        if (!this.defaultValue.isEmpty()) {
            return this.defaultValue;
        }
        String defaultValue = DocGeneratorUtil.getPrimitiveDefaultValue(this.type);
        if (defaultValue == null) {
            return "";
        }
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ConfigPhase getConfigPhase() {
        return this.configPhase;
    }

    public void setConfigPhase(ConfigPhase configPhase) {
        this.configPhase = configPhase;
    }

    public void setWithinAMap(boolean withinAMap) {
        this.withinAMap = withinAMap;
    }

    public boolean isWithinAMap() {
        return this.withinAMap;
    }

    String computeTypeSimpleName() {
        String unwrappedType = DocGeneratorUtil.unbox(this.type);
        Matcher matcher = Constants.CLASS_NAME_PATTERN.matcher(unwrappedType);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return unwrappedType;
    }

    @Override
    public int compareTo(ConfigItem item) {
        if (this.withinAMap) {
            if (item.withinAMap) {
                return 0;
            }
            return 1;
        }
        if (item.withinAMap) {
            return -1;
        }
        int phaseComparison = ConfigPhase.COMPARATOR.compare(this.configPhase, item.configPhase);
        if (phaseComparison == 0) {
            return 0;
        }
        return phaseComparison;
    }
}

