/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;

public class ExtensionAnnotationProcessor
extends AbstractProcessor {
    private static final String ANNOTATION_BUILD_STEP = "io.quarkus.deployment.annotations.BuildStep";
    private static final String ANNOTATION_CONFIG_GROUP = "io.quarkus.runtime.annotations.ConfigGroup";
    private static final String ANNOTATION_CONFIG_ITEM = "io.quarkus.runtime.annotations.ConfigItem";
    private static final String ANNOTATION_CONFIG_ROOT = "io.quarkus.runtime.annotations.ConfigRoot";
    private static final String ANNOTATION_TEMPLATE = "io.quarkus.runtime.annotations.Template";
    private static final String INSTANCE_SYM = "__instance";
    private final Set<String> generatedAccessors = new ConcurrentHashMap().keySet(Boolean.TRUE);
    private final Set<String> generatedJavaDocs = new ConcurrentHashMap().keySet(Boolean.TRUE);

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> ret = new HashSet<String>();
        ret.add(ANNOTATION_BUILD_STEP);
        ret.add(ANNOTATION_CONFIG_GROUP);
        ret.add(ANNOTATION_CONFIG_ROOT);
        ret.add(ANNOTATION_TEMPLATE);
        return ret;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.doProcess(annotations, roundEnv);
        if (roundEnv.processingOver()) {
            this.doFinish();
        }
        return true;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptySet();
    }

    public void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            switch (typeElement.getQualifiedName().toString()) {
                case "io.quarkus.deployment.annotations.BuildStep": {
                    this.processBuildStep(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.ConfigGroup": {
                    this.processConfigGroup(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.ConfigRoot": {
                    this.processConfigRoot(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.Template": {
                    this.processTemplate(roundEnv, typeElement);
                }
            }
        }
    }

    void doFinish() {
        Throwable throwable;
        BufferedWriter bw2;
        Throwable throwable2;
        OutputStreamWriter osw2;
        Throwable throwable3;
        BufferedOutputStream bos2;
        Throwable throwable4;
        OutputStream os;
        FileObject listResource;
        Path path;
        FileObject tempResource;
        Filer filer = this.processingEnv.getFiler();
        try {
            tempResource = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "ignore.tmp", new Element[0]);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create temp output file: " + e);
            return;
        }
        URI uri = tempResource.toUri();
        try {
            path = Paths.get(uri).getParent();
        }
        catch (RuntimeException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Resource path URI is invalid: " + uri);
            return;
        }
        final TreeSet bscListClasses = new TreeSet();
        final TreeSet crListClasses = new TreeSet();
        final Properties javaDocProperties = new Properties();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String nameStr = file.getFileName().toString();
                    if (nameStr.endsWith(".bsc")) {
                        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                            String line;
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).isEmpty()) continue;
                                bscListClasses.add(line);
                            }
                        }
                        catch (IOException e) {
                            ExtensionAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read file " + file + ": " + e);
                        }
                    } else if (nameStr.endsWith(".cr")) {
                        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                            String line;
                            while ((line = br.readLine()) != null) {
                                if ((line = line.trim()).isEmpty()) continue;
                                crListClasses.add(line);
                            }
                        }
                        catch (IOException e) {
                            ExtensionAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read file " + file + ": " + e);
                        }
                    } else if (nameStr.endsWith(".jdp")) {
                        Properties p = new Properties();
                        try {
                            BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                            Object object = null;
                            try {
                                p.load(br);
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (br != null) {
                                    if (object != null) {
                                        try {
                                            br.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        br.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            ExtensionAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read file " + file + ": " + e);
                        }
                        Set<String> names = p.stringPropertyNames();
                        for (String name : names) {
                            javaDocProperties.setProperty(name, p.getProperty(name));
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    ExtensionAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to visit file " + file + ": " + exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "File walk failed: " + e);
        }
        if (!bscListClasses.isEmpty()) {
            try {
                listResource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quarkus-build-steps.list", new Element[0]);
                os = listResource.openOutputStream();
                throwable4 = null;
                try {
                    bos2 = new BufferedOutputStream(os);
                    throwable3 = null;
                    try {
                        osw2 = new OutputStreamWriter((OutputStream)bos2, StandardCharsets.UTF_8);
                        throwable2 = null;
                        try {
                            bw2 = new BufferedWriter(osw2);
                            throwable = null;
                            try {
                                for (String item : bscListClasses) {
                                    bw2.write(item);
                                    bw2.newLine();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (bw2 != null) {
                                    if (throwable != null) {
                                        try {
                                            bw2.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                    } else {
                                        bw2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable bw2) {
                            throwable2 = bw2;
                            throw bw2;
                        }
                        finally {
                            if (osw2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        osw2.close();
                                    }
                                    catch (Throwable bw2) {
                                        throwable2.addSuppressed(bw2);
                                    }
                                } else {
                                    osw2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable osw2) {
                        throwable3 = osw2;
                        throw osw2;
                    }
                    finally {
                        if (bos2 != null) {
                            if (throwable3 != null) {
                                try {
                                    bos2.close();
                                }
                                catch (Throwable osw2) {
                                    throwable3.addSuppressed(osw2);
                                }
                            } else {
                                bos2.close();
                            }
                        }
                    }
                }
                catch (Throwable bos2) {
                    throwable4 = bos2;
                    throw bos2;
                }
                finally {
                    if (os != null) {
                        if (throwable4 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable bos2) {
                                throwable4.addSuppressed(bos2);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write build steps listing: " + e);
                return;
            }
        }
        if (!crListClasses.isEmpty()) {
            try {
                listResource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quarkus-config-roots.list", new Element[0]);
                os = listResource.openOutputStream();
                throwable4 = null;
                try {
                    bos2 = new BufferedOutputStream(os);
                    throwable3 = null;
                    try {
                        osw2 = new OutputStreamWriter((OutputStream)bos2, StandardCharsets.UTF_8);
                        throwable2 = null;
                        try {
                            bw2 = new BufferedWriter(osw2);
                            throwable = null;
                            try {
                                for (String item : crListClasses) {
                                    bw2.write(item);
                                    bw2.newLine();
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable = throwable7;
                                throw throwable7;
                            }
                            finally {
                                if (bw2 != null) {
                                    if (throwable != null) {
                                        try {
                                            bw2.close();
                                        }
                                        catch (Throwable throwable8) {
                                            throwable.addSuppressed(throwable8);
                                        }
                                    } else {
                                        bw2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable bw3) {
                            throwable2 = bw3;
                            throw bw3;
                        }
                        finally {
                            if (osw2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        osw2.close();
                                    }
                                    catch (Throwable bw3) {
                                        throwable2.addSuppressed(bw3);
                                    }
                                } else {
                                    osw2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable osw3) {
                        throwable3 = osw3;
                        throw osw3;
                    }
                    finally {
                        if (bos2 != null) {
                            if (throwable3 != null) {
                                try {
                                    bos2.close();
                                }
                                catch (Throwable osw3) {
                                    throwable3.addSuppressed(osw3);
                                }
                            } else {
                                bos2.close();
                            }
                        }
                    }
                }
                catch (Throwable bos3) {
                    throwable4 = bos3;
                    throw bos3;
                }
                finally {
                    if (os != null) {
                        if (throwable4 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable bos3) {
                                throwable4.addSuppressed(bos3);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write config roots listing: " + e);
                return;
            }
        }
        try {
            listResource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quarkus-javadoc.properties", new Element[0]);
            os = listResource.openOutputStream();
            throwable4 = null;
            try {
                bos2 = new BufferedOutputStream(os);
                throwable3 = null;
                try {
                    osw2 = new OutputStreamWriter((OutputStream)bos2, StandardCharsets.UTF_8);
                    throwable2 = null;
                    try {
                        bw2 = new BufferedWriter(osw2);
                        throwable = null;
                        try {
                            javaDocProperties.store(bw2, "");
                        }
                        catch (Throwable throwable9) {
                            throwable = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (bw2 != null) {
                                if (throwable != null) {
                                    try {
                                        bw2.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable.addSuppressed(throwable10);
                                    }
                                } else {
                                    bw2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable11) {
                        throwable2 = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (osw2 != null) {
                            if (throwable2 != null) {
                                try {
                                    osw2.close();
                                }
                                catch (Throwable throwable12) {
                                    throwable2.addSuppressed(throwable12);
                                }
                            } else {
                                osw2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable13) {
                    throwable3 = throwable13;
                    throw throwable13;
                }
                finally {
                    if (bos2 != null) {
                        if (throwable3 != null) {
                            try {
                                bos2.close();
                            }
                            catch (Throwable throwable14) {
                                throwable3.addSuppressed(throwable14);
                            }
                        } else {
                            bos2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable15) {
                throwable4 = throwable15;
                throw throwable15;
            }
            finally {
                if (os != null) {
                    if (throwable4 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable16) {
                            throwable4.addSuppressed(throwable16);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write javadoc properties: " + e);
            return;
        }
    }

    private void processBuildStep(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> processorClassNames = new HashSet<String>();
        for (ExecutableElement i : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            TypeElement clazz = this.getClassOf(i);
            if (clazz == null) continue;
            PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(clazz);
            if (pkg == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + clazz + " has no enclosing package");
                continue;
            }
            String binaryName = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
            if (!processorClassNames.add(binaryName)) continue;
            this.recordConfigJavadoc(clazz);
            this.generateAccessor(clazz);
            StringBuilder rbn = this.getRelativeBinaryName(clazz, new StringBuilder());
            try {
                FileObject itemResource = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg.getQualifiedName().toString(), rbn.toString() + ".bsc", clazz);
                OutputStream os = itemResource.openOutputStream();
                Throwable throwable = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    Throwable throwable2 = null;
                    try {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
                        Throwable throwable3 = null;
                        try {
                            BufferedWriter bw = new BufferedWriter(osw);
                            Throwable throwable4 = null;
                            try {
                                bw.write(binaryName);
                                bw.newLine();
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (bw == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        bw.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                bw.close();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable3 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (osw == null) continue;
                            if (throwable3 != null) {
                                try {
                                    osw.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            osw.close();
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable2 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (os == null) continue;
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    os.close();
                }
            }
            catch (IOException e1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create " + rbn + " in " + pkg + ": " + e1, clazz);
            }
        }
    }

    private StringBuilder getRelativeBinaryName(TypeElement te, StringBuilder b) {
        Element enclosing = te.getEnclosingElement();
        if (enclosing instanceof TypeElement) {
            this.getRelativeBinaryName((TypeElement)enclosing, b);
            b.append('$');
        }
        b.append(te.getSimpleName());
        return b;
    }

    private TypeElement getClassOf(Element e) {
        Element t = e;
        while (!(t instanceof TypeElement)) {
            if (t == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + e + " has no enclosing class");
                return null;
            }
            t = t.getEnclosingElement();
        }
        return (TypeElement)t;
    }

    private void recordConfigJavadoc(TypeElement clazz) {
        if (!this.generatedJavaDocs.add(clazz.getQualifiedName().toString())) {
            return;
        }
        Properties javadocProps = new Properties();
        for (Element element : clazz.getEnclosedElements()) {
            switch (element.getKind()) {
                case FIELD: {
                    if (!ExtensionAnnotationProcessor.isAnnotationPresent(element, ANNOTATION_CONFIG_ITEM)) break;
                    this.processFieldConfigItem((VariableElement)element, javadocProps);
                    break;
                }
                case CONSTRUCTOR: {
                    ExecutableElement ex = (ExecutableElement)element;
                    if (!ExtensionAnnotationProcessor.hasParameterAnnotated(ex, ANNOTATION_CONFIG_ITEM)) break;
                    this.processCtorConfigItem(ex, javadocProps);
                    break;
                }
                case METHOD: {
                    ExecutableElement ex = (ExecutableElement)element;
                    if (!ExtensionAnnotationProcessor.hasParameterAnnotated(ex, ANNOTATION_CONFIG_ITEM)) break;
                    this.processMethodConfigItem(ex, javadocProps);
                    break;
                }
            }
        }
        if (javadocProps.isEmpty()) {
            return;
        }
        PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(clazz);
        String string = this.getRelativeBinaryName(clazz, new StringBuilder()).append(".jdp").toString();
        try {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg.getQualifiedName().toString(), string, clazz);
            try (Writer writer = file.openWriter();){
                javadocProps.store(writer, "");
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to persist resource " + string + ": " + e);
        }
    }

    private void processFieldConfigItem(VariableElement field, Properties javadocProps) {
        javadocProps.put(field.getSimpleName().toString(), this.getRequiredJavadoc(field));
    }

    private void processCtorConfigItem(ExecutableElement ctor, Properties javadocProps) {
        String docComment = this.getRequiredJavadoc(ctor);
        StringBuilder buf = new StringBuilder();
        this.appendParamTypes(ctor, buf);
        javadocProps.put(buf.toString(), docComment);
    }

    private void processMethodConfigItem(ExecutableElement method, Properties javadocProps) {
        String docComment = this.getRequiredJavadoc(method);
        StringBuilder buf = new StringBuilder();
        buf.append(method.getSimpleName().toString());
        this.appendParamTypes(method, buf);
        javadocProps.put(buf.toString(), docComment);
    }

    private void processConfigGroup(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> groupClassNames = new HashSet<String>();
        for (TypeElement i : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (!groupClassNames.add(i.getQualifiedName().toString())) continue;
            this.generateAccessor(i);
            this.recordConfigJavadoc(i);
        }
    }

    private void processConfigRoot(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> rootClassNames = new HashSet<String>();
        for (TypeElement clazz : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(clazz);
            if (pkg == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + clazz + " has no enclosing package");
                continue;
            }
            String binaryName = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
            if (!rootClassNames.add(binaryName)) continue;
            this.recordConfigJavadoc(clazz);
            this.generateAccessor(clazz);
            StringBuilder rbn = this.getRelativeBinaryName(clazz, new StringBuilder());
            try {
                FileObject itemResource = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg.getQualifiedName().toString(), rbn.toString() + ".cr", clazz);
                OutputStream os = itemResource.openOutputStream();
                Throwable throwable = null;
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(os);
                    Throwable throwable2 = null;
                    try {
                        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
                        Throwable throwable3 = null;
                        try {
                            BufferedWriter bw = new BufferedWriter(osw);
                            Throwable throwable4 = null;
                            try {
                                bw.write(binaryName);
                                bw.newLine();
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (bw == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        bw.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                bw.close();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable3 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (osw == null) continue;
                            if (throwable3 != null) {
                                try {
                                    osw.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            osw.close();
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (bos == null) continue;
                        if (throwable2 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        bos.close();
                    }
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (os == null) continue;
                    if (throwable != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    os.close();
                }
            }
            catch (IOException e1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create " + rbn + " in " + pkg + ": " + e1, clazz);
            }
        }
    }

    private void processTemplate(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> groupClassNames = new HashSet<String>();
        for (TypeElement i : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (!groupClassNames.add(i.getQualifiedName().toString())) continue;
            this.generateAccessor(i);
            this.recordConfigJavadoc(i);
        }
    }

    private void generateAccessor(TypeElement clazz) {
        DeclaredType declaredType;
        TypeMirror enclosingType;
        if (!this.generatedAccessors.add(clazz.getQualifiedName().toString())) {
            return;
        }
        FormatPreferences fp = new FormatPreferences();
        JSources sources = JDeparser.createSources((JFiler)JFiler.newInstance((Filer)this.processingEnv.getFiler()), (FormatPreferences)fp);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(clazz);
        String className = this.getRelativeBinaryName(clazz, new StringBuilder()).append("$$accessor").toString();
        JSourceFile sourceFile = sources.createSourceFile(packageElement.getQualifiedName().toString(), className);
        JType clazzType = JTypes.typeOf((TypeMirror)clazz.asType());
        if (clazz.asType() instanceof DeclaredType && (enclosingType = (declaredType = (DeclaredType)clazz.asType()).getEnclosingType()) != null && enclosingType.getKind() == TypeKind.DECLARED && clazz.getModifiers().contains((Object)Modifier.STATIC)) {
            clazzType = this.unnestStaticNestedType(declaredType);
        }
        JClassDef classDef = sourceFile._class(34, className);
        classDef.constructor(8);
        JAssignableExpr instanceName = JExprs.name((String)INSTANCE_SYM);
        for (VariableElement field : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
            Set<Modifier> mods = field.getModifiers();
            if (mods.contains((Object)Modifier.PRIVATE) || mods.contains((Object)Modifier.STATIC)) continue;
            TypeMirror fieldType = field.asType();
            JType jType = JTypes.typeOf((TypeMirror)fieldType);
            JType publicType = fieldType instanceof PrimitiveType ? jType : JType.OBJECT;
            String fieldName = field.getSimpleName().toString();
            JMethodDef jMethodDef = classDef.method(96, publicType, "get_" + fieldName);
            jMethodDef.annotate(SuppressWarnings.class).value("unchecked");
            jMethodDef.param(JType.OBJECT, INSTANCE_SYM);
            jMethodDef.body()._return((JExpr)instanceName.cast(clazzType).field(fieldName));
            JMethodDef setter = classDef.method(96, JType.VOID, "set_" + fieldName);
            setter.annotate(SuppressWarnings.class).value("unchecked");
            setter.param(JType.OBJECT, INSTANCE_SYM);
            setter.param(publicType, fieldName);
            JAssignableExpr fieldExpr = JExprs.name((String)fieldName);
            setter.body().assign(instanceName.cast(clazzType).field(fieldName), (JExpr)(publicType.equals(jType) ? fieldExpr : fieldExpr.cast(jType)));
        }
        for (ExecutableElement ctor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
            if (ctor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            StringBuilder b = new StringBuilder();
            for (VariableElement variableElement : ctor.getParameters()) {
                b.append('_');
                b.append(variableElement.asType().toString().replace('.', '_'));
            }
            String codedName = b.toString();
            JMethodDef jMethodDef = classDef.method(96, JType.OBJECT, "construct" + codedName);
            JCall ctorCall = clazzType._new();
            for (VariableElement variableElement : ctor.getParameters()) {
                TypeMirror paramType = variableElement.asType();
                JType realType = JTypes.typeOf((TypeMirror)paramType);
                JType publicType = paramType instanceof PrimitiveType ? realType : JType.OBJECT;
                String name = variableElement.getSimpleName().toString();
                jMethodDef.param(publicType, name);
                JAssignableExpr nameExpr = JExprs.name((String)name);
                ctorCall.arg((JExpr)(publicType.equals(realType) ? nameExpr : nameExpr.cast(realType)));
            }
            jMethodDef.body()._return((JExpr)ctorCall);
        }
        try {
            sources.writeSources();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate source file: " + e, clazz);
        }
    }

    private JType unnestStaticNestedType(DeclaredType declaredType) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String name = typeElement.getQualifiedName().toString();
        JType rawType = JTypes.typeNamed((String)name);
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return rawType;
        }
        JType[] args = new JType[typeArguments.size()];
        for (int i = 0; i < typeArguments.size(); ++i) {
            TypeMirror argument = typeArguments.get(i);
            args[i] = JTypes.typeOf((TypeMirror)argument);
        }
        return rawType.typeArg(args);
    }

    private void appendParamTypes(ExecutableElement ex, StringBuilder buf) {
        List<? extends VariableElement> params = ex.getParameters();
        if (params.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Expected at least one parameter", ex);
            return;
        }
        VariableElement param = params.get(0);
        DeclaredType dt = (DeclaredType)param.asType();
        String typeName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
        buf.append('(').append(typeName);
        for (int i = 1; i < params.size(); ++i) {
            param = params.get(i);
            dt = (DeclaredType)param.asType();
            typeName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
            buf.append(',').append(typeName);
        }
        buf.append(')');
    }

    private String getRequiredJavadoc(Element e) {
        String docComment = this.processingEnv.getElementUtils().getDocComment(e);
        if (docComment == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to find javadoc for config item " + e, e);
            return "";
        }
        return docComment.trim();
    }

    private static boolean hasParameterAnnotated(ExecutableElement ex, String annotationName) {
        for (VariableElement variableElement : ex.getParameters()) {
            if (!ExtensionAnnotationProcessor.isAnnotationPresent(variableElement, annotationName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(Element element, String annotationName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString().equals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

