/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.Binaries;
import io.quarkus.cli.plugin.CatalogService;
import io.quarkus.cli.plugin.JBangCatalog;
import io.quarkus.cli.plugin.JBangCatalogService;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCatalog;
import io.quarkus.cli.plugin.PluginCatalogService;
import io.quarkus.cli.plugin.PluginManagerSettings;
import io.quarkus.cli.plugin.PluginManagerUtil;
import io.quarkus.cli.plugin.PluginType;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.registry.catalog.Extension;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class PluginMangerState {
    private final PluginManagerSettings settings;
    private final MessageWriter output;
    private final PluginManagerUtil util;
    private final Optional<Path> userHome;
    private final Optional<Path> projectRoot;
    private final Supplier<QuarkusProject> quarkusProject;
    private final PluginCatalogService pluginCatalogService;
    private final JBangCatalogService jbangCatalogService;
    private Map<String, Plugin> _userPlugins;
    private Map<String, Plugin> _projectPlugins;
    private Map<String, Plugin> _installedPlugins;
    private Map<String, Plugin> _installablePlugins;
    private Map<String, Plugin> _extensionPlugins;
    private Optional<PluginCatalog> _userCatalog;
    private Optional<PluginCatalog> _projectCatalog;
    private PluginCatalog _combinedCatalog;

    PluginMangerState(PluginManagerSettings settings, MessageWriter output, Optional<Path> userHome, Optional<Path> currentDir, Supplier<QuarkusProject> quarkusProject) {
        this.settings = settings;
        this.output = output;
        this.userHome = userHome;
        this.quarkusProject = quarkusProject;
        this.jbangCatalogService = new JBangCatalogService(settings.isInteractiveMode(), output, settings.getPluginPrefix(), settings.getFallbackJBangCatalog(), settings.getRemoteJBangCatalogs());
        this.pluginCatalogService = new PluginCatalogService(settings.getToRelativePath());
        this.projectRoot = currentDir.flatMap(CatalogService::findProjectRoot);
        this.util = PluginManagerUtil.getUtil(settings);
    }

    public PluginCatalogService getPluginCatalogService() {
        return this.pluginCatalogService;
    }

    public JBangCatalogService getJbangCatalogService() {
        return this.jbangCatalogService;
    }

    public Map<String, Plugin> installedPlugins() {
        HashMap<String, Plugin> allInstalledPlugins = new HashMap<String, Plugin>();
        allInstalledPlugins.putAll(this.userPlugins());
        allInstalledPlugins.putAll(this.projectPlugins());
        return allInstalledPlugins;
    }

    public Map<String, Plugin> getInstalledPluigns() {
        if (this._installedPlugins == null) {
            this._installedPlugins = this.installedPlugins();
        }
        return Collections.unmodifiableMap(this._installedPlugins);
    }

    public Map<String, Plugin> projectPlugins() {
        return this.pluginCatalogService.readProjectCatalog(this.projectRoot).map(catalog -> catalog.getPlugins().values().stream().map(Plugin::inProjectCatalog).collect(Collectors.toMap(p -> p.getName(), p -> p))).orElse(Collections.emptyMap());
    }

    public Map<String, Plugin> getProjectPluigns() {
        if (this._projectPlugins == null) {
            this._projectPlugins = this.projectPlugins();
        }
        return Collections.unmodifiableMap(this._projectPlugins);
    }

    public Map<String, Plugin> userPlugins() {
        return this.pluginCatalogService.readUserCatalog(this.userHome).map(catalog -> catalog.getPlugins().values().stream().map(Plugin::inUserCatalog).collect(Collectors.toMap(p -> p.getName(), p -> p))).orElse(Collections.emptyMap());
    }

    public Map<String, Plugin> getUserPluigns() {
        if (this._userPlugins == null) {
            this._userPlugins = this.userPlugins();
        }
        return Collections.unmodifiableMap(this._userPlugins);
    }

    public Map<String, Plugin> installablePlugins(List<PluginType> types) {
        HashMap<String, Plugin> installablePlugins = new HashMap<String, Plugin>();
        for (PluginType type : types) {
            switch (type) {
                case jbang: {
                    installablePlugins.putAll(this.jbangPlugins());
                    break;
                }
                case executable: {
                    installablePlugins.putAll(this.executablePlugins());
                }
            }
        }
        installablePlugins.putAll(this.executablePlugins().entrySet().stream().filter(e -> types.contains((Object)((Plugin)e.getValue()).getType())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Plugin)e.getValue())));
        return installablePlugins;
    }

    public Map<String, Plugin> installablePlugins(PluginType ... types) {
        return this.installablePlugins(List.of(types));
    }

    public Map<String, Plugin> installablePlugins() {
        return this.installablePlugins(PluginType.values());
    }

    public Map<String, Plugin> getInstallablePlugins() {
        if (this._installablePlugins == null) {
            this._installablePlugins = this.installablePlugins();
        }
        return Collections.unmodifiableMap(this._installablePlugins);
    }

    public Map<String, Plugin> jbangPlugins() {
        boolean isUserScoped = !this.projectRoot.isPresent();
        HashMap<String, Plugin> jbangPlugins = new HashMap<String, Plugin>();
        this.jbangCatalogService.ensureJBangIsInstalled();
        JBangCatalog jbangCatalog = this.jbangCatalogService.readCombinedCatalog(this.projectRoot, this.userHome);
        jbangCatalog.getAliases().forEach((location, alias) -> {
            String name = this.util.getName((String)location);
            Optional<String> description = alias.getDescription();
            Plugin plugin = new Plugin(name, PluginType.jbang, Optional.of(location), description, Optional.empty(), isUserScoped);
            jbangPlugins.put(name, plugin);
        });
        return jbangPlugins;
    }

    public Map<String, Plugin> executablePlugins() {
        boolean isUserScoped = !this.projectRoot.isPresent();
        HashMap<String, Plugin> executablePlugins = new HashMap<String, Plugin>();
        Binaries.findQuarkusPrefixedCommands().forEach(f -> {
            String name = this.util.getName(f.getName());
            Optional<String> description = Optional.empty();
            Optional<String> location = Optional.of(f.getAbsolutePath());
            Plugin plugin = new Plugin(name, PluginType.executable, location, description, Optional.empty(), isUserScoped);
            executablePlugins.put(name, plugin);
        });
        return executablePlugins;
    }

    public Map<String, Plugin> extensionPlugins() {
        HashMap<String, Plugin> extensionPlugins = new HashMap<String, Plugin>();
        this.projectRoot.map(r -> this.quarkusProject.get()).ifPresent(project -> {
            try {
                Set installed = project.getExtensionManager().getInstalled().stream().map(ArtifactCoords::getKey).collect(Collectors.toSet());
                for (Extension e : project.getExtensionsCatalog().getExtensions()) {
                    if (!installed.contains(e.getArtifact().getKey())) continue;
                    for (String cliPlugin : ExtensionProcessor.getCliPlugins(e)) {
                        Plugin plugin = cliPlugin.contains(": ") ? this.util.fromAlias(cliPlugin) : this.util.fromLocation(cliPlugin);
                        extensionPlugins.put(plugin.getName(), plugin);
                    }
                }
            }
            catch (Exception ignore) {
                this.output.warn("Failed to read the extension catalog. Ignoring extension plugins.");
            }
        });
        return extensionPlugins;
    }

    public Map<String, Plugin> getExtensionPlugins() {
        if (this._extensionPlugins == null) {
            this._extensionPlugins = this.extensionPlugins();
        }
        return Collections.unmodifiableMap(this._extensionPlugins);
    }

    public Optional<PluginCatalog> projectCatalog() {
        return this.projectRoot.flatMap(p -> this.pluginCatalogService.readProjectCatalog(Optional.of(p)));
    }

    public Optional<PluginCatalog> getProjectCatalog() {
        if (this._projectCatalog == null) {
            this._projectCatalog = this.pluginCatalogService.readProjectCatalog(this.projectRoot);
        }
        return this._projectCatalog;
    }

    public Optional<PluginCatalog> userCatalog() {
        return this.userHome.flatMap(h -> this.pluginCatalogService.readUserCatalog(Optional.of(h)));
    }

    public Optional<PluginCatalog> getUserCatalog() {
        if (this._userCatalog == null) {
            this._userCatalog = this.userCatalog();
        }
        return this._userCatalog;
    }

    public PluginCatalog combinedCatalog() {
        return PluginCatalog.combine(this.getUserCatalog(), this.getProjectCatalog());
    }

    public PluginCatalog getCombinedCatalog() {
        if (this._combinedCatalog == null) {
            this._combinedCatalog = this.combinedCatalog();
        }
        return this._combinedCatalog;
    }

    public PluginCatalog pluginCatalog(boolean userCatalog) {
        return (userCatalog ? this.getUserCatalog() : this.getProjectCatalog()).or(() -> this.getUserCatalog()).orElseThrow(() -> new IllegalStateException("Unable to get project and user plugin catalogs!"));
    }

    public Optional<Path> getProjectRoot() {
        return this.projectRoot;
    }

    public void invalidateInstalledPlugins() {
        this._userPlugins = null;
        this._projectPlugins = null;
        this._installedPlugins = null;
    }

    public void invalidate() {
        this._userPlugins = null;
        this._projectPlugins = null;
        this._installedPlugins = null;
        this._installablePlugins = null;
        this._extensionPlugins = null;
    }
}

