/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.devtools.project.state.ModuleState;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;

public class InfoCommandHandler
implements QuarkusCommandHandler {
    public static final String APP_MODEL = "app-model";
    public static final String LOG_STATE_PER_MODULE = "log-state-per-module";
    public static final String RECOMMENDATIONS_AVAILABLE = "recommendations-available";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        ApplicationModel appModel = (ApplicationModel)invocation.getValue(APP_MODEL);
        boolean logStatePerModule = invocation.getValue(LOG_STATE_PER_MODULE, false);
        boolean recommendationsAvailable = InfoCommandHandler.logState(InfoCommandHandler.resolveProjectState(appModel, invocation.getExtensionsCatalog()), logStatePerModule, false, invocation.log());
        return (QuarkusCommandOutcome)QuarkusCommandOutcome.success().setValue(RECOMMENDATIONS_AVAILABLE, recommendationsAvailable);
    }

    protected static boolean logState(ProjectState projectState, boolean perModule, boolean rectify, MessageWriter log) {
        boolean recommendationsAvailable = false;
        LinkedHashMap<io.quarkus.maven.dependency.ArtifactKey, PlatformInfo> providerInfo = new LinkedHashMap<io.quarkus.maven.dependency.ArtifactKey, PlatformInfo>();
        Iterator<Object> iterator = projectState.getPlatformBoms().iterator();
        while (iterator.hasNext()) {
            ArtifactCoords artifactCoords;
            providerInfo.computeIfAbsent(artifactCoords.getKey(), (Function<io.quarkus.maven.dependency.ArtifactKey, PlatformInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$logState$0(io.quarkus.maven.dependency.ArtifactKey ), (Lio/quarkus/maven/dependency/ArtifactKey;)Lio/quarkus/devtools/commands/handlers/InfoCommandHandler$PlatformInfo;)()).imported = artifactCoords = iterator.next();
        }
        for (TopExtensionDependency topExtensionDependency : projectState.getExtensions()) {
            ExtensionOrigin origin = topExtensionDependency.getOrigin();
            if (origin == null || !origin.isPlatform()) continue;
            providerInfo.computeIfAbsent(origin.getBom().getKey(), (Function<io.quarkus.maven.dependency.ArtifactKey, PlatformInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$logState$1(io.quarkus.maven.dependency.ArtifactKey ), (Lio/quarkus/maven/dependency/ArtifactKey;)Lio/quarkus/devtools/commands/handlers/InfoCommandHandler$PlatformInfo;)()).recommended = origin.getBom();
        }
        if (providerInfo.isEmpty()) {
            log.info("No Quarkus platform BOMs found");
        } else {
            log.info("Quarkus platform BOMs:");
            boolean recommendExtraImports = false;
            for (PlatformInfo platform : providerInfo.values()) {
                if (platform.imported == null) {
                    recommendExtraImports = true;
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                if (platform.recommended == null) {
                    if (rectify) {
                        sb.append(String.format("%-7s %s", "Remove:", platform.imported.toCompactCoords()));
                    } else {
                        sb.append("  ");
                        sb.append(platform.imported.toCompactCoords()).append(" | unnecessary");
                    }
                    recommendationsAvailable = true;
                } else if (platform.isVersionUpdateRecommended()) {
                    if (rectify) {
                        sb.append(String.format("%-7s %s", "Update:", platform.imported.toCompactCoords()));
                        sb.append(platform.imported.toCompactCoords()).append(" -> ").append(platform.getRecommendedVersion());
                    } else {
                        sb.append("  ");
                        sb.append(platform.imported.toCompactCoords()).append(" | misaligned");
                    }
                    recommendationsAvailable = true;
                } else if (rectify) {
                    sb.append(String.format("%-7s %s", "", platform.imported.toCompactCoords()));
                } else {
                    sb.append("  ").append(platform.imported.toCompactCoords());
                }
                log.info(sb.toString());
            }
            if (rectify && recommendExtraImports) {
                for (PlatformInfo platform : providerInfo.values()) {
                    if (platform.imported != null) continue;
                    log.info(String.format("%-7s %s", "Add:", platform.recommended.toCompactCoords()));
                }
                recommendationsAvailable = true;
            }
        }
        if (projectState.getExtensions().isEmpty()) {
            log.info("No Quarkus extensions found among the project dependencies");
            return recommendationsAvailable;
        }
        log.info("");
        if (perModule) {
            ModuleState mainModule = projectState.getMainModule();
            Path path = mainModule.getModuleDir();
            recommendationsAvailable |= InfoCommandHandler.logModuleInfo(projectState, mainModule, path, log, rectify);
            for (ModuleState module : projectState.getModules()) {
                if (module.isMain()) continue;
                recommendationsAvailable |= InfoCommandHandler.logModuleInfo(projectState, module, path, log, rectify);
            }
        } else {
            for (ExtensionProvider extensionProvider : projectState.getExtensionProviders()) {
                if (!extensionProvider.isPlatform()) continue;
                recommendationsAvailable = InfoCommandHandler.logProvidedExtensions(extensionProvider, rectify, log, recommendationsAvailable);
            }
            for (ExtensionProvider extensionProvider : projectState.getExtensionProviders()) {
                if (extensionProvider.isPlatform()) continue;
                recommendationsAvailable = InfoCommandHandler.logProvidedExtensions(extensionProvider, rectify, log, recommendationsAvailable);
            }
        }
        return recommendationsAvailable;
    }

    private static boolean logProvidedExtensions(ExtensionProvider provider, boolean rectify, MessageWriter log, boolean recommendationsAvailable) {
        if (provider.getExtensions().isEmpty()) {
            return recommendationsAvailable;
        }
        log.info("Extensions from " + provider.getKey() + ":");
        StringBuilder sb = new StringBuilder();
        for (TopExtensionDependency dep : provider.getExtensions()) {
            sb.setLength(0);
            recommendationsAvailable = InfoCommandHandler.logExtensionInfo(dep, rectify, sb, recommendationsAvailable);
            log.info(sb.toString());
        }
        log.info("");
        return recommendationsAvailable;
    }

    private static boolean logExtensionInfo(TopExtensionDependency dep, boolean rectify, StringBuilder sb, boolean recommendationsAvailable) {
        if (dep.isPlatformExtension()) {
            if (rectify) {
                if (dep.isNonRecommendedVersion()) {
                    sb.append(String.format("%-7s %s", "Update:", ""));
                } else {
                    sb.append(String.format("%-7s %s", "", ""));
                }
                sb.append(dep.getArtifact().getGroupId()).append(':').append(dep.getArtifact().getArtifactId());
                if (!dep.getArtifact().getClassifier().isEmpty()) {
                    sb.append(':').append(dep.getArtifact().getClassifier());
                }
                if (dep.isNonRecommendedVersion()) {
                    sb.append(':').append(dep.getArtifact().getVersion());
                    if (rectify) {
                        sb.append(" -> remove version (managed)");
                    }
                    recommendationsAvailable = true;
                }
            } else {
                sb.append("  ").append(dep.getArtifact().getGroupId()).append(':').append(dep.getArtifact().getArtifactId());
                if (!dep.getArtifact().getClassifier().isEmpty()) {
                    sb.append(':').append(dep.getArtifact().getClassifier());
                }
                if (dep.isNonRecommendedVersion()) {
                    sb.append(':').append(dep.getArtifact().getVersion());
                    sb.append(" | misaligned");
                    recommendationsAvailable = true;
                }
            }
        } else {
            if (rectify) {
                sb.append(String.format("%-7s %s", "", ""));
            } else {
                sb.append("  ");
            }
            sb.append(dep.getArtifact().toCompactCoords());
        }
        if (dep.isTransitive()) {
            sb.append(" | transitive");
        }
        return recommendationsAvailable;
    }

    private static boolean logModuleInfo(ProjectState project, ModuleState module, Path baseDir, MessageWriter log, boolean rectify) {
        if (module.getExtensions().isEmpty() && module.getPlatformBoms().isEmpty() && !module.isMain()) {
            return false;
        }
        boolean recommendationsAvailable = false;
        StringBuilder sb = new StringBuilder();
        if (module.isMain()) {
            sb.append("Main application module ");
        } else {
            sb.append("Module ");
        }
        sb.append(module.getId().getGroupId()).append(':').append(module.getId().getArtifactId()).append(':');
        log.info(sb.toString());
        Iterator i = module.getWorkspaceModule().getBuildFiles().iterator();
        if (i.hasNext()) {
            sb.setLength(0);
            sb.append("  Build file: ");
            sb.append(baseDir.relativize((Path)i.next()));
            while (i.hasNext()) {
                sb.append(", ").append(baseDir.relativize((Path)i.next()));
            }
            log.info(sb.toString());
        }
        if (!module.getPlatformBoms().isEmpty()) {
            log.info("  Platform BOMs:");
            for (ArtifactCoords bom : module.getPlatformBoms()) {
                log.info("    " + bom.toCompactCoords());
            }
        }
        if (!module.getExtensions().isEmpty()) {
            List extList;
            LinkedHashMap extDepsByProvider = new LinkedHashMap();
            for (TopExtensionDependency dep : module.getExtensions()) {
                extDepsByProvider.computeIfAbsent(dep.getProviderKey(), k -> new ArrayList()).add(dep);
            }
            for (ExtensionProvider provider : project.getExtensionProviders()) {
                if (!provider.isPlatform() || (extList = extDepsByProvider.getOrDefault(provider.getKey(), Collections.emptyList())).isEmpty()) continue;
                log.info("  Extensions from " + provider.getKey() + ":");
                for (TopExtensionDependency dep : extList) {
                    sb.setLength(0);
                    sb.append("  ");
                    recommendationsAvailable = InfoCommandHandler.logExtensionInfo(dep, rectify, sb, recommendationsAvailable);
                    log.info(sb.toString());
                }
                log.info("");
            }
            for (ExtensionProvider provider : project.getExtensionProviders()) {
                if (provider.isPlatform() || (extList = extDepsByProvider.getOrDefault(provider.getKey(), Collections.emptyList())).isEmpty()) continue;
                log.info("  Extensions from " + provider.getKey() + ":");
                for (TopExtensionDependency dep : extList) {
                    sb.setLength(0);
                    sb.append("  ");
                    recommendationsAvailable = InfoCommandHandler.logExtensionInfo(dep, rectify, sb, recommendationsAvailable);
                    log.info(sb.toString());
                }
                log.info("");
            }
        }
        return recommendationsAvailable;
    }

    protected static ProjectState resolveProjectState(ApplicationModel appModel, ExtensionCatalog currentCatalog) {
        ProjectState.Builder projectBuilder = ProjectState.builder();
        Collection importedPlatformBoms = appModel.getPlatforms().getImportedPlatformBoms();
        if (importedPlatformBoms.isEmpty()) {
            return projectBuilder.build();
        }
        LinkedHashMap<String, ExtensionProvider.Builder> extProviderBuilders = new LinkedHashMap<String, ExtensionProvider.Builder>(importedPlatformBoms.size());
        importedPlatformBoms.forEach(bom -> {
            projectBuilder.addPlatformBom((ArtifactCoords)bom);
            extProviderBuilders.put(ExtensionProvider.key(bom, true), ExtensionProvider.builder().setArtifact((ArtifactCoords)bom).setPlatform(true));
        });
        HashMap<WorkspaceModuleId, Object> projectModuleBuilders = new HashMap<WorkspaceModuleId, Object>();
        HashMap directModuleDeps = new HashMap();
        WorkspaceModule appModule = appModel.getAppArtifact().getWorkspaceModule();
        if (appModule != null) {
            ModuleState.Builder module = ModuleState.builder().setWorkspaceModule(appModule).setMainModule(true);
            projectModuleBuilders.put(appModule.getId(), module);
            appModule.getDirectDependencies().forEach(d -> directModuleDeps.computeIfAbsent(d.getKey(), dk -> new ArrayList()).add(module));
            for (Dependency constraint : appModule.getDirectDependencyConstraints()) {
                if (!extProviderBuilders.containsKey(constraint.toCompactCoords())) continue;
                module.addPlatformBom((ArtifactCoords)constraint);
            }
        }
        for (ResolvedDependency dep : appModel.getDependencies()) {
            if (dep.getWorkspaceModule() == null) continue;
            projectModuleBuilders.computeIfAbsent(dep.getWorkspaceModule().getId(), k -> {
                ModuleState.Builder module = ModuleState.builder().setWorkspaceModule(dep.getWorkspaceModule());
                dep.getWorkspaceModule().getDirectDependencies().forEach(d -> directModuleDeps.computeIfAbsent(d.getKey(), dk -> new ArrayList()).add(module));
                return module;
            });
        }
        HashMap<io.quarkus.maven.dependency.ArtifactKey, TopExtensionDependency.Builder> directExtDeps = new HashMap<io.quarkus.maven.dependency.ArtifactKey, TopExtensionDependency.Builder>();
        for (ResolvedDependency dep : appModel.getDependencies()) {
            if (dep.isFlagSet(128)) {
                directExtDeps.put(dep.getKey(), TopExtensionDependency.builder().setResolvedDependency(dep).setTransitive(!directModuleDeps.containsKey(dep.getKey())));
                continue;
            }
            if (!dep.isRuntimeExtensionArtifact() || !directModuleDeps.containsKey(dep.getKey())) continue;
            directExtDeps.put(dep.getKey(), TopExtensionDependency.builder().setResolvedDependency(dep));
        }
        if (directExtDeps.isEmpty()) {
            return projectBuilder.build();
        }
        currentCatalog.getExtensions().forEach(e -> {
            ArtifactKey key = e.getArtifact().getKey();
            TopExtensionDependency.Builder dep = (TopExtensionDependency.Builder)directExtDeps.get(key);
            if (dep != null) {
                dep.setCatalogMetadata((Extension)e);
            }
        });
        for (TopExtensionDependency.Builder extBuilder : directExtDeps.values()) {
            List modules = directModuleDeps.getOrDefault(extBuilder.getKey(), Collections.emptyList());
            TopExtensionDependency dep = extBuilder.setTransitive(modules.isEmpty()).build();
            projectBuilder.addExtensionDependency(dep);
            for (ModuleState.Builder module : modules) {
                module.addExtensionDependency(dep);
            }
            ExtensionProvider.Builder provider = extProviderBuilders.computeIfAbsent(dep.getProviderKey(), k -> ExtensionProvider.builder().setOrigin(dep.getOrigin()));
            provider.addExtension(dep);
        }
        for (Object builder : extProviderBuilders.values()) {
            projectBuilder.addExtensionProvider(((ExtensionProvider.Builder)builder).build());
        }
        for (Object builder : projectModuleBuilders.values()) {
            projectBuilder.addModule(((ModuleState.Builder)builder).build());
        }
        return projectBuilder.build();
    }

    private static /* synthetic */ PlatformInfo lambda$logState$1(io.quarkus.maven.dependency.ArtifactKey k) {
        return new PlatformInfo();
    }

    private static /* synthetic */ PlatformInfo lambda$logState$0(io.quarkus.maven.dependency.ArtifactKey k) {
        return new PlatformInfo();
    }

    static class PlatformInfo {
        ArtifactCoords imported;
        ArtifactCoords recommended;

        PlatformInfo() {
        }

        boolean isVersionUpdateRecommended() {
            return this.imported != null && this.recommended != null && !this.imported.getVersion().equals(this.recommended.getVersion());
        }

        String getRecommendedVersion() {
            return this.recommended == null ? null : this.recommended.getVersion();
        }

        boolean isImported() {
            return this.imported != null;
        }

        boolean isToBeImported() {
            return this.imported == null && this.recommended != null;
        }

        ArtifactCoords getRecommendedCoords() {
            return this.recommended == null ? this.imported : this.recommended;
        }

        String getRecommendedProviderKey() {
            if (this.recommended != null) {
                return ExtensionProvider.key(this.recommended, true);
            }
            return ExtensionProvider.key(this.imported, true);
        }
    }
}

