/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor.loader.json;

import io.quarkus.fs.util.ZipUtils;
import io.quarkus.platform.descriptor.loader.json.ResourceLoader;
import io.quarkus.platform.descriptor.loader.json.ResourcePathConsumer;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ZipResourceLoader
implements ResourceLoader {
    private final Path zip;

    public ZipResourceLoader(Path zip) {
        this.zip = zip;
    }

    @Override
    public <T> T loadResourceAsPath(String name, ResourcePathConsumer<T> consumer) throws IOException {
        try (FileSystem fs = ZipUtils.newFileSystem((Path)this.zip);){
            Path path = fs.getPath("/", name);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IOException("Failed to locate " + name + " in " + this.zip);
            }
            T t = consumer.consume(path);
            return t;
        }
    }
}

