/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.model.ArtifactKey;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableArtifactKey
implements ArtifactKey {
    private final String groupId;
    private final String artifactId;

    private ImmutableArtifactKey(String groupId, String artifactId) {
        this.groupId = Objects.requireNonNull(groupId, "groupId");
        this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
    }

    private ImmutableArtifactKey(ImmutableArtifactKey original, String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    @JsonProperty(value="group-id")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifact-id")
    public String getArtifactId() {
        return this.artifactId;
    }

    public final ImmutableArtifactKey withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableArtifactKey(this, newValue, this.artifactId);
    }

    public final ImmutableArtifactKey withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableArtifactKey(this, this.groupId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArtifactKey && this.equalTo((ImmutableArtifactKey)another);
    }

    private boolean equalTo(ImmutableArtifactKey another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        return h;
    }

    public String toString() {
        return "ArtifactKey{groupId=" + this.groupId + ", artifactId=" + this.artifactId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableArtifactKey fromJson(Json json) {
        Builder builder = ImmutableArtifactKey.builder();
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.artifactId != null) {
            builder.artifactId(json.artifactId);
        }
        return builder.build();
    }

    public static ImmutableArtifactKey of(String groupId, String artifactId) {
        return new ImmutableArtifactKey(groupId, artifactId);
    }

    public static ImmutableArtifactKey copyOf(ArtifactKey instance) {
        if (instance instanceof ImmutableArtifactKey) {
            return (ImmutableArtifactKey)instance;
        }
        return ImmutableArtifactKey.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private long initBits = 3L;
        private String groupId;
        private String artifactId;

        private Builder() {
        }

        public final Builder from(ArtifactKey instance) {
            Objects.requireNonNull(instance, "instance");
            this.groupId(instance.getGroupId());
            this.artifactId(instance.getArtifactId());
            return this;
        }

        @JsonProperty(value="group-id")
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="artifact-id")
        public final Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableArtifactKey build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArtifactKey(null, this.groupId, this.artifactId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build ArtifactKey, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ArtifactKey {
        String groupId;
        String artifactId;

        Json() {
        }

        @JsonProperty(value="group-id")
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="artifact-id")
        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getArtifactId() {
            throw new UnsupportedOperationException();
        }
    }
}

