/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.builder;

import io.quarkus.registry.builder.RegistryBuilder;
import io.quarkus.registry.model.ArtifactCoords;
import java.util.ArrayList;
import java.util.Objects;

public final class ImmutableArtifactCoordsTuple
implements RegistryBuilder.ArtifactCoordsTuple {
    private final ArtifactCoords coords;
    private final String quarkusVersion;

    private ImmutableArtifactCoordsTuple(ArtifactCoords coords, String quarkusVersion) {
        this.coords = Objects.requireNonNull(coords, "coords");
        this.quarkusVersion = Objects.requireNonNull(quarkusVersion, "quarkusVersion");
    }

    private ImmutableArtifactCoordsTuple(ImmutableArtifactCoordsTuple original, ArtifactCoords coords, String quarkusVersion) {
        this.coords = coords;
        this.quarkusVersion = quarkusVersion;
    }

    @Override
    public ArtifactCoords getCoords() {
        return this.coords;
    }

    @Override
    public String getQuarkusVersion() {
        return this.quarkusVersion;
    }

    public final ImmutableArtifactCoordsTuple withCoords(ArtifactCoords value) {
        if (this.coords == value) {
            return this;
        }
        ArtifactCoords newValue = Objects.requireNonNull(value, "coords");
        return new ImmutableArtifactCoordsTuple(this, newValue, this.quarkusVersion);
    }

    public final ImmutableArtifactCoordsTuple withQuarkusVersion(String value) {
        String newValue = Objects.requireNonNull(value, "quarkusVersion");
        if (this.quarkusVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableArtifactCoordsTuple(this, this.coords, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableArtifactCoordsTuple && this.equalTo((ImmutableArtifactCoordsTuple)another);
    }

    private boolean equalTo(ImmutableArtifactCoordsTuple another) {
        return this.coords.equals(another.coords) && this.quarkusVersion.equals(another.quarkusVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coords.hashCode();
        h += (h << 5) + this.quarkusVersion.hashCode();
        return h;
    }

    public String toString() {
        return "ArtifactCoordsTuple{coords=" + this.coords + ", quarkusVersion=" + this.quarkusVersion + "}";
    }

    public static ImmutableArtifactCoordsTuple of(ArtifactCoords coords, String quarkusVersion) {
        return new ImmutableArtifactCoordsTuple(coords, quarkusVersion);
    }

    public static ImmutableArtifactCoordsTuple copyOf(RegistryBuilder.ArtifactCoordsTuple instance) {
        if (instance instanceof ImmutableArtifactCoordsTuple) {
            return (ImmutableArtifactCoordsTuple)instance;
        }
        return ImmutableArtifactCoordsTuple.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_COORDS = 1L;
        private static final long INIT_BIT_QUARKUS_VERSION = 2L;
        private long initBits = 3L;
        private ArtifactCoords coords;
        private String quarkusVersion;

        private Builder() {
        }

        public final Builder from(RegistryBuilder.ArtifactCoordsTuple instance) {
            Objects.requireNonNull(instance, "instance");
            this.coords(instance.getCoords());
            this.quarkusVersion(instance.getQuarkusVersion());
            return this;
        }

        public final Builder coords(ArtifactCoords coords) {
            this.coords = Objects.requireNonNull(coords, "coords");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder quarkusVersion(String quarkusVersion) {
            this.quarkusVersion = Objects.requireNonNull(quarkusVersion, "quarkusVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableArtifactCoordsTuple build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableArtifactCoordsTuple(null, this.coords, this.quarkusVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("coords");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("quarkusVersion");
            }
            return "Cannot build ArtifactCoordsTuple, some of required attributes are not set " + attributes;
        }
    }
}

