/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.templates.rest;

import io.quarkus.maven.utilities.MojoUtils;
import io.quarkus.templates.QuarkusTemplate;
import io.quarkus.templates.SourceType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;

public class BasicRest
implements QuarkusTemplate {
    public static final String TEMPLATE_NAME = "basic-rest";
    private Map<String, Object> context;
    private String path = "/hello";
    private File projectRoot;
    private File srcMain;
    private File testMain;
    private SourceType type;

    @Override
    public String getName() {
        return TEMPLATE_NAME;
    }

    @Override
    public void generate(File projectRoot, Map<String, Object> parameters) throws IOException {
        this.projectRoot = projectRoot;
        this.context = parameters == null ? Collections.emptyMap() : parameters;
        this.type = (SourceType)((Object)this.context.get("source_type"));
        this.initProject();
        this.setupContext();
        this.createClasses();
        this.createIndexPage();
        this.createDockerFiles();
        this.createDockerIgnore();
        this.createApplicationConfig();
    }

    private void setupContext() {
        if (this.context.get("class_name") != null) {
            String packageName = (String)this.context.get("package_name");
            if (packageName != null) {
                File packageDir = new File(this.srcMain, packageName.replace('.', '/'));
                File testPackageDir = new File(this.testMain, packageName.replace('.', '/'));
                this.srcMain = this.mkdirs(packageDir);
                this.testMain = this.mkdirs(testPackageDir);
            } else {
                throw new NullPointerException("Need a non-null package name");
            }
        }
    }

    private void createClasses() throws IOException {
        Object className = this.context.get("class_name");
        if (className != null) {
            String extension = this.type.getExtension();
            File classFile = new File(this.srcMain, className + extension);
            File testClassFile = new File(this.testMain, className + "Test" + extension);
            File itTestClassFile = new File(this.testMain, "Native" + className + "IT" + extension);
            String name = this.getName();
            this.generate(this.type.getSrcResourceTemplate(name), this.context, classFile, "resource code");
            this.generate(this.type.getTestResourceTemplate(name), this.context, testClassFile, "test code");
            this.generate(this.type.getNativeTestResourceTemplate(name), this.context, itTestClassFile, "IT code");
        }
    }

    private <T> T get(String key, String defaultValue) {
        return (T)this.context.getOrDefault(key, defaultValue);
    }

    private boolean initProject() throws IOException {
        boolean newProject;
        File pomFile = new File(this.projectRoot, "pom.xml");
        boolean bl = newProject = !pomFile.exists();
        if (newProject) {
            this.generate(this.type.getPomResourceTemplate(this.getName()), this.context, pomFile, "pom.xml");
        } else {
            Model model = MojoUtils.readPom(pomFile);
            this.context.put("project_groupId", model.getGroupId());
            this.context.put("project_artifactId", model.getArtifactId());
        }
        this.path = (String)this.get("path", this.path);
        this.srcMain = this.mkdirs(new File(this.projectRoot, this.type.getSrcDir()));
        this.testMain = this.mkdirs(new File(this.projectRoot, this.type.getTestSrcDir()));
        return newProject;
    }

    private void generate(String templateName, Map<String, Object> context, File outputFile, String resourceType) throws IOException {
        if (!outputFile.exists()) {
            String path = templateName.startsWith("/") ? templateName : "/" + templateName;
            try (BufferedWriter out = Files.newBufferedWriter(outputFile.toPath(), new OpenOption[0]);
                 BufferedReader stream = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
                String template = stream.lines().collect(Collectors.joining("\n"));
                for (Map.Entry<String, Object> e : context.entrySet()) {
                    if (e.getValue() == null) continue;
                    template = template.replace(String.format("${%s}", e.getKey()), e.getValue().toString());
                }
                out.write(template);
            }
        }
    }

    private void createIndexPage() throws IOException {
        File resources = new File(this.projectRoot, "src/main/resources/META-INF/resources");
        File index = new File(this.mkdirs(resources), "index.html");
        if (!index.exists()) {
            this.generate("templates/index.ftl", this.context, index, "welcome page");
        }
    }

    private void createDockerFiles() throws IOException {
        File dockerRoot = new File(this.projectRoot, "src/main/docker");
        this.generate("templates/dockerfile-native.ftl", this.context, new File(this.mkdirs(dockerRoot), "Dockerfile.native"), "native docker file");
        this.generate("templates/dockerfile-jvm.ftl", this.context, new File(this.mkdirs(dockerRoot), "Dockerfile.jvm"), "jvm docker file");
    }

    private void createDockerIgnore() throws IOException {
        File dockerRoot = new File(this.projectRoot, "");
        File docker = new File(this.mkdirs(dockerRoot), ".dockerignore");
        this.generate("templates/dockerignore.ftl", this.context, docker, "docker ignore");
    }

    private void createApplicationConfig() throws IOException {
        File meta = new File(this.projectRoot, "src/main/resources");
        File file = new File(this.mkdirs(meta), "application.properties");
        if (!file.exists()) {
            Files.write(file.toPath(), Arrays.asList("# Configuration file", "# key = value"), StandardOpenOption.CREATE_NEW);
            System.out.println("Configuration file created in src/main/resources/META-INF/" + file.getName());
        }
    }

    private File mkdirs(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

