/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.commands;

import io.quarkus.dependencies.Extension;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;

public class AddExtensions {
    private Model model;
    private File pom;

    public AddExtensions(File pom) throws IOException {
        this.model = MojoUtils.readPom(pom);
        this.pom = pom;
    }

    public boolean addExtensions(Set<String> extensions) throws IOException {
        if (extensions == null || extensions.isEmpty()) {
            return false;
        }
        boolean updated = false;
        List<Dependency> dependenciesFromBom = this.getDependenciesFromBom();
        for (String dependency : extensions) {
            Optional<Extension> optional = MojoUtils.loadExtensions().stream().filter(d -> {
                boolean hasTag = d.labels().contains(dependency.trim().toLowerCase());
                boolean machName = d.getName().toLowerCase().contains(dependency.trim().toLowerCase());
                return hasTag || machName;
            }).findAny();
            if (optional.isPresent()) {
                Extension extension = optional.get();
                if (!MojoUtils.hasDependency(this.model, extension.getGroupId(), extension.getArtifactId())) {
                    System.out.println("Adding extension " + extension.managementKey());
                    this.model.addDependency(extension.toDependency(this.containsBOM(this.model) && this.isDefinedInBom(dependenciesFromBom, extension)));
                    updated = true;
                    continue;
                }
                System.out.println("Skipping extension " + extension.managementKey() + ": already present");
                continue;
            }
            if (dependency.contains(":")) {
                Dependency parsed = MojoUtils.parse(dependency);
                System.out.println("Adding dependency " + parsed.getManagementKey());
                this.model.addDependency(parsed);
                updated = true;
                continue;
            }
            System.out.println("Cannot find a dependency matching '" + dependency + "'");
        }
        if (updated) {
            MojoUtils.write(this.model, this.pom);
        }
        return updated;
    }

    private List<Dependency> getDependenciesFromBom() {
        try {
            return MojoUtils.readPom(this.getClass().getResourceAsStream("/quarkus-bom/pom.xml")).getDependencyManagement().getDependencies();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean containsBOM(Model model) {
        if (model.getDependencyManagement() == null) {
            return false;
        }
        List dependencies = model.getDependencyManagement().getDependencies();
        return dependencies.stream().filter(dependency -> "import".equalsIgnoreCase(dependency.getScope())).filter(dependency -> "pom".equalsIgnoreCase(dependency.getType())).anyMatch(dependency -> dependency.getArtifactId().equalsIgnoreCase(MojoUtils.getBomArtifactId()));
    }

    private boolean isDefinedInBom(List<Dependency> dependencies, Extension extension) {
        return dependencies.stream().anyMatch(dependency -> dependency.getGroupId().equalsIgnoreCase(extension.getGroupId()) && dependency.getArtifactId().equalsIgnoreCase(extension.getArtifactId()));
    }
}

