/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import jakarta.annotation.Priority;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class CharsetConverter
implements Converter<Charset>,
Serializable {
    private static final long serialVersionUID = 2320905063828247874L;

    public Charset convert(String value) {
        if (value == null) {
            return null;
        }
        String trimmedCharset = value.trim();
        if (trimmedCharset.isEmpty()) {
            return null;
        }
        try {
            return Charset.forName(trimmedCharset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create Charset from: '" + trimmedCharset + "'", e);
        }
    }
}

