/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import jakarta.annotation.Priority;
import java.io.Serializable;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class DurationConverter
implements Converter<Duration>,
Serializable {
    private static final long serialVersionUID = 7499347081928776532L;
    private static final String PERIOD_OF_TIME = "PT";
    private static final Pattern DIGITS = Pattern.compile("^[-+]?\\d+$");
    private static final Pattern START_WITH_DIGITS = Pattern.compile("^[-+]?\\d+.*");

    public Duration convert(String value) {
        return DurationConverter.parseDuration(value);
    }

    public static Duration parseDuration(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        if (DIGITS.asPredicate().test(value)) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        try {
            if (START_WITH_DIGITS.asPredicate().test(value)) {
                return Duration.parse(PERIOD_OF_TIME + value);
            }
            return Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

