/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.launcher.QuarkusLauncher;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.logging.JBossVersion;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class Quarkus {
    private static Closeable LAUNCHED_FROM_IDE;

    public static void run(Class<? extends QuarkusApplication> quarkusApplication, String ... args) {
        Quarkus.run(quarkusApplication, null, args);
    }

    public static void run(Class<? extends QuarkusApplication> quarkusApplication, BiConsumer<Integer, Throwable> exitHandler, String ... args) {
        try {
            JBossVersion.disableVersionLogging();
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
            System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", "io.quarkus.bootstrap.forkjoin.QuarkusForkJoinWorkerThreadFactory");
            Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl", false, Thread.currentThread().getContextClassLoader());
            Application application = (Application)appClass.newInstance();
            ApplicationLifecycleManager.run(application, quarkusApplication, exitHandler, args);
            return;
        }
        catch (ClassNotFoundException appClass) {
        }
        catch (Exception e) {
            if (exitHandler != null) {
                exitHandler.accept(1, e);
            } else {
                Logger.getLogger(Quarkus.class).error((Object)"Error running Quarkus", (Throwable)e);
                ApplicationLifecycleManager.getDefaultExitCodeHandler().accept(1, e);
            }
            return;
        }
        Quarkus.launchFromIDE(quarkusApplication, args);
    }

    private static void launchFromIDE(Class<? extends QuarkusApplication> quarkusApplication, String ... args) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int pos = 2;
        while (stackTrace[pos].getClassName().equals(Quarkus.class.getName())) {
            ++pos;
        }
        String callingClass = stackTrace[pos].getClassName();
        LAUNCHED_FROM_IDE = QuarkusLauncher.launch((String)callingClass, (String)(quarkusApplication == null ? null : quarkusApplication.getName()), (String[])args);
    }

    private static void terminateForIDE() {
        if (LAUNCHED_FROM_IDE != null) {
            try {
                LAUNCHED_FROM_IDE.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void run(String ... args) {
        Quarkus.run(null, args);
    }

    public static void asyncExit(int code) {
        Quarkus.terminateForIDE();
        ApplicationLifecycleManager.exit(code);
    }

    public static void asyncExit() {
        Quarkus.terminateForIDE();
        ApplicationLifecycleManager.exit(-1);
    }

    public static void waitForExit() {
        ApplicationLifecycleManager.waitForExit();
    }

    public static void blockingExit() {
        Application app = Application.currentApplication();
        Quarkus.asyncExit();
        if (app != null) {
            app.awaitShutdown();
        }
    }
}

