/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.runtime.Application;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.graal.DiagnosticPrinter;
import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logging.Logger;
import org.wildfly.common.lock.Locks;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ApplicationLifecycleManager {
    private static volatile Consumer<Integer> defaultExitCodeHandler = new Consumer<Integer>(){

        @Override
        public void accept(Integer integer) {
            System.exit(integer);
        }
    };
    private static final String DISABLE_SIGNAL_HANDLERS = "DISABLE_SIGNAL_HANDLERS";
    private static final Lock stateLock = Locks.reentrantLock();
    private static final Condition stateCond = stateLock.newCondition();
    private static int exitCode = -1;
    private static boolean shutdownRequested;
    private static Application currentApplication;
    private static boolean hooksRegistered;
    private static boolean vmShuttingDown;

    private ApplicationLifecycleManager() {
    }

    public static void run(Application application, String ... args) {
        ApplicationLifecycleManager.run(application, null, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Application application, Class<? extends QuarkusApplication> quarkusApplication, Consumer<Integer> exitCodeHandler, String ... args) {
        boolean alreadyStarted;
        block30: {
            stateLock.lock();
            alreadyStarted = application.isStarted();
            if (!hooksRegistered) {
                ApplicationLifecycleManager.registerHooks(exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler);
                hooksRegistered = true;
            }
            if (currentApplication != null && !shutdownRequested) {
                throw new IllegalStateException("Quarkus already running");
            }
            try {
                exitCode = -1;
                shutdownRequested = false;
                currentApplication = application;
            }
            finally {
                stateLock.unlock();
            }
            boolean appStarted = false;
            try {
                application.start(args);
                appStarted = true;
                if (quarkusApplication != null) {
                    QuarkusApplication instance;
                    BeanManager beanManager = CDI.current().getBeanManager();
                    Set beans = beanManager.getBeans(quarkusApplication, new Annotation[]{Any.Literal.INSTANCE});
                    Bean bean = null;
                    for (Bean i : beans) {
                        if (i.getBeanClass() != quarkusApplication) continue;
                        bean = i;
                        break;
                    }
                    if (bean == null) {
                        instance = quarkusApplication.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        CreationalContext ctx = beanManager.createCreationalContext(bean);
                        instance = (QuarkusApplication)beanManager.getReference(bean, quarkusApplication, ctx);
                    }
                    int result = -1;
                    try {
                        result = instance.run(args);
                        break block30;
                    }
                    finally {
                        stateLock.lock();
                        try {
                            if (exitCode == -1 && result != -1) {
                                exitCode = result;
                            }
                            shutdownRequested = true;
                            stateCond.signalAll();
                        }
                        finally {
                            stateLock.unlock();
                        }
                    }
                }
                stateLock.lock();
                try {
                    while (!shutdownRequested) {
                        Thread.interrupted();
                        stateCond.await();
                    }
                }
                finally {
                    stateLock.unlock();
                }
            }
            catch (Exception e) {
                if (appStarted) {
                    Logger.getLogger(Application.class).error((Object)"Error running Quarkus application", (Throwable)e);
                }
                stateLock.lock();
                try {
                    shutdownRequested = true;
                    stateCond.signalAll();
                }
                finally {
                    stateLock.unlock();
                }
                application.stop();
                (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(1);
                return;
            }
        }
        if (!alreadyStarted) {
            application.stop();
        }
        (exitCodeHandler == null ? defaultExitCodeHandler : exitCodeHandler).accept(ApplicationLifecycleManager.getExitCode());
    }

    private static void registerHooks(Consumer<Integer> exitCodeHandler) {
        if (ImageInfo.inImageRuntimeCode() && System.getenv(DISABLE_SIGNAL_HANDLERS) == null) {
            ApplicationLifecycleManager.registerSignalHandlers(exitCodeHandler);
        }
        ShutdownHookThread shutdownHookThread = new ShutdownHookThread();
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    private static void registerSignalHandlers(final Consumer<Integer> exitCodeHandler) {
        SignalHandler exitHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                exitCodeHandler.accept(signal.getNumber() + 128);
            }
        };
        SignalHandler diagnosticsHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                DiagnosticPrinter.printDiagnostics(System.out);
            }
        };
        ApplicationLifecycleManager.handleSignal("INT", exitHandler);
        ApplicationLifecycleManager.handleSignal("TERM", exitHandler);
        if (System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH).contains("windows")) {
            ApplicationLifecycleManager.handleSignal("BREAK", diagnosticsHandler);
        } else {
            ApplicationLifecycleManager.handleSignal("HUP", exitHandler);
            ApplicationLifecycleManager.handleSignal("QUIT", diagnosticsHandler);
        }
    }

    public static int getExitCode() {
        return exitCode == -1 ? 0 : exitCode;
    }

    public static void exit() {
        ApplicationLifecycleManager.exit(-1);
    }

    public static Consumer<Integer> getDefaultExitCodeHandler() {
        return defaultExitCodeHandler;
    }

    public static boolean isVmShuttingDown() {
        return vmShuttingDown;
    }

    public static void setDefaultExitCodeHandler(Consumer<Integer> defaultExitCodeHandler) {
        Objects.requireNonNull(defaultExitCodeHandler);
        ApplicationLifecycleManager.defaultExitCodeHandler = defaultExitCodeHandler;
    }

    public static void exit(int code) {
        stateLock.lock();
        try {
            if (code >= 0 && exitCode == -1) {
                exitCode = code;
            }
            if (shutdownRequested) {
                return;
            }
            shutdownRequested = true;
            stateCond.signalAll();
        }
        finally {
            stateLock.unlock();
        }
    }

    public static void waitForExit() {
        stateLock.lock();
        try {
            while (!shutdownRequested) {
                stateCond.awaitUninterruptibly();
            }
        }
        finally {
            stateLock.unlock();
        }
    }

    private static void handleSignal(String signal, SignalHandler handler) {
        try {
            Signal.handle(new Signal(signal), handler);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("Shutdown thread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            stateLock.lock();
            vmShuttingDown = true;
            shutdownRequested = true;
            try {
                stateCond.signalAll();
            }
            finally {
                stateLock.unlock();
            }
            if (currentApplication.isStarted()) {
                currentApplication.stop();
            }
            currentApplication.awaitShutdown();
            System.out.flush();
            System.err.flush();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

