/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration.ssl;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.configuration.ssl.CertificateConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import org.jboss.logging.Logger;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.Protocol;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLContextBuilder;

@ConfigGroup
public class ServerSslConfig {
    public CertificateConfig certificate;
    @ConfigItem
    public Optional<CipherSuiteSelector> cipherSuites;
    @ConfigItem(defaultValue="TLSv1.3,TLSv1.2")
    public List<Protocol> protocols;
    @ConfigItem
    public Optional<String> providerName;
    @ConfigItem
    public OptionalInt sessionCacheSize;
    @ConfigItem
    public Optional<Duration> sessionTimeout;

    public SSLContext toSSLContext() throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        Logger log = Logger.getLogger((String)"io.quarkus.configuration.ssl");
        Optional<Path> certFile = this.certificate.file;
        Optional<Path> keyFile = this.certificate.keyFile;
        Optional<Path> keyStoreFile = this.certificate.keyStoreFile;
        String keystorePassword = this.certificate.keyStorePassword;
        if (certFile.isPresent() && keyFile.isPresent()) {
            PrivateKey entryKey;
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, keystorePassword.toCharArray());
            Path certPath = certFile.get();
            Iterator certItr = Pem.parsePemContent((CodePointIterator)ServerSslConfig.load(certPath));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            while (certItr.hasNext()) {
                PemEntry item = (PemEntry)certItr.next();
                X509Certificate cert = (X509Certificate)item.tryCast(X509Certificate.class);
                if (cert != null) {
                    certList.add(cert);
                    continue;
                }
                log.warnf("Ignoring non-certificate in certificate file \"%s\" (the type was %s)", (Object)certPath, item.getEntry().getClass());
            }
            if (certList.isEmpty()) {
                log.warnf("No certificate found in file \"%s\"", (Object)certPath);
            }
            Path keyPath = keyFile.get();
            Iterator keyItr = Pem.parsePemContent((CodePointIterator)ServerSslConfig.load(keyPath));
            while (true) {
                if (!keyItr.hasNext()) {
                    log.warnf("No key found in file \"%s\"", (Object)keyPath);
                    return null;
                }
                PemEntry next = (PemEntry)keyItr.next();
                entryKey = (PrivateKey)next.tryCast(PrivateKey.class);
                if (entryKey != null) break;
                log.warnf("Ignoring non-key in key file \"%s\" (the type was %s)", (Object)keyPath, next.getEntry().getClass());
            }
            PrivateKey privateKey = entryKey;
            if (keyItr.hasNext()) {
                log.warnf("Ignoring extra content in key file \"%s\"", (Object)keyPath);
            }
            keyStore.setEntry("default", new KeyStore.PrivateKeyEntry(privateKey, certList.toArray(new X509Certificate[0])), new KeyStore.PasswordProtection(keystorePassword.toCharArray()));
        } else if (keyStoreFile.isPresent()) {
            String pathName;
            Path keyStorePath = keyStoreFile.get();
            Optional<String> keyStoreFileType = this.certificate.keyStoreFileType;
            String type = keyStoreFileType.isPresent() ? keyStoreFileType.get() : ((pathName = keyStorePath.toString()).endsWith(".jks") ? "jks" : (pathName.endsWith(".jceks") ? "jceks" : (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx") ? "pkcs12" : "jks")));
            keyStore = KeyStore.getInstance(type);
            InputStream keystoreAsResource = this.getClass().getClassLoader().getResourceAsStream(keyStorePath.toString());
            if (keystoreAsResource != null) {
                try (InputStream is = keystoreAsResource;){
                    keyStore.load(is, null);
                }
            } else {
                try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
                    keyStore.load(is, null);
                }
            }
        } else {
            return null;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        sslContextBuilder.setCipherSuiteSelector(this.cipherSuites.orElse(CipherSuiteSelector.openSslDefault()));
        ProtocolSelector protocolSelector = this.protocols.isEmpty() ? ProtocolSelector.defaultProtocols() : ProtocolSelector.empty().add(this.protocols.toArray(new Protocol[0]));
        sslContextBuilder.setProtocolSelector(protocolSelector);
        sslContextBuilder.setKeyManager((X509ExtendedKeyManager)keyManagerFactory.getKeyManagers()[0]);
        if (this.sessionCacheSize.isPresent()) {
            sslContextBuilder.setSessionCacheSize(this.sessionCacheSize.getAsInt());
        }
        if (this.sessionTimeout.isPresent()) {
            sslContextBuilder.setSessionTimeout((int)Math.min(Integer.MAX_VALUE, this.sessionTimeout.get().getSeconds()));
        }
        if (this.providerName.isPresent()) {
            sslContextBuilder.setProviderName(this.providerName.get());
        }
        return (SSLContext)sslContextBuilder.build().create();
    }

    static CodePointIterator load(Path path) throws IOException {
        int c;
        int size = Math.toIntExact(Files.size(path));
        char[] chars = new char[size];
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int res;
            for (c = 0; c < size; c += res) {
                res = isr.read(chars, c, size - c);
                if (res != -1) continue;
                break;
            }
        }
        return CodePointIterator.ofChars((char[])chars, (int)0, (int)c);
    }
}

