/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.spi;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ContainerImageInfoBuildItem
extends SimpleBuildItem {
    private static final String SLASH = "/";
    private static final String COLN = ":";
    public final Optional<String> registry;
    public final Optional<String> username;
    public final Optional<String> password;
    private final String imagePrefix;
    private final String repository;
    private final String tag;
    private final Set<String> additionalTags;

    public ContainerImageInfoBuildItem(Optional<String> registry, Optional<String> username, Optional<String> password, String repository, String tag, List<String> additionalTags) {
        this.registry = registry;
        this.username = username;
        this.password = password;
        this.repository = repository;
        StringBuilder sb = new StringBuilder();
        registry.ifPresent(r -> sb.append((String)r).append(SLASH));
        sb.append(repository);
        this.imagePrefix = sb.toString();
        this.tag = tag;
        this.additionalTags = new HashSet<String>(additionalTags);
    }

    public ContainerImageInfoBuildItem(Optional<String> registry, Optional<String> username, Optional<String> password, Optional<String> group, String name, String tag, List<String> additionalTags) {
        this.registry = registry;
        this.username = username;
        this.password = password;
        StringBuilder imagePrefixSB = new StringBuilder();
        StringBuilder repositorySB = new StringBuilder();
        registry.ifPresent(r -> imagePrefixSB.append((String)r).append(SLASH));
        group.ifPresent(s -> repositorySB.append((String)s).append(SLASH));
        repositorySB.append(name);
        this.repository = repositorySB.toString();
        this.imagePrefix = imagePrefixSB.append(this.repository).toString();
        this.tag = tag;
        this.additionalTags = new HashSet<String>(additionalTags);
    }

    public Optional<String> getRegistry() {
        return this.registry;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public String getImage() {
        return this.imagePrefix + COLN + this.tag;
    }

    public String getTag() {
        return this.tag;
    }

    public List<String> getAdditionalImageTags() {
        return this.getAdditionalTags().stream().map(tag -> this.imagePrefix + COLN + tag).collect(Collectors.toList());
    }

    public Set<String> getAdditionalTags() {
        return this.additionalTags;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getGroup() {
        return this.repository == null ? null : this.repository.split(SLASH)[0];
    }
}

