/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

public abstract class EnumBuildOption<E extends Enum<E>, T>
extends AbstractBuildOption<T, CommandLineOptionConfiguration> {
    private final String displayName;
    private final Class<E> enumClass;
    private final List<E> possibleValues;

    public EnumBuildOption(String displayName, Class<E> enumClass, E[] possibleValues, String gradleProperty, String deprecatedProperty, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(gradleProperty, deprecatedProperty, commandLineOptionConfigurations);
        this.displayName = displayName;
        this.enumClass = enumClass;
        this.possibleValues = Collections.unmodifiableList(Arrays.asList(possibleValues));
    }

    public EnumBuildOption(String displayName, Class<E> enumClass, E[] possibleValues, String gradleProperty, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        this(displayName, enumClass, (Enum[])possibleValues, gradleProperty, null, commandLineOptionConfigurations);
    }

    @Override
    public void applyFromProperty(Map<String, String> properties, T settings) {
        AbstractBuildOption.OptionValue<String> propertyValue = this.getFromProperties(properties);
        String value = propertyValue.getValue();
        if (value != null) {
            this.applyTo((E)value, settings, propertyValue.getOrigin());
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating()).hasArgument();
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (!options.hasOption(config.getLongOption())) continue;
            String value = options.option(config.getLongOption()).getValue();
            this.applyTo((E)value, settings, Origin.forCommandLine(config.getLongOption()));
        }
    }

    private void applyTo(String value, T settings, Origin origin) {
        this.applyTo(this.getValue(value), settings, origin);
    }

    private E getValue(String value) {
        E enumValue = null;
        if (value != null) {
            enumValue = this.tryGetValue(value);
            if (enumValue == null) {
                enumValue = this.tryGetValue(value.toLowerCase());
            }
            if (enumValue == null) {
                enumValue = this.tryGetValue(value.toUpperCase());
            }
        }
        if (enumValue == null) {
            throw new RuntimeException("Option " + this.displayName + " doesn't accept value '" + value + "'. Possible values are " + this.possibleValues);
        }
        return enumValue;
    }

    private E tryGetValue(String value) {
        try {
            return Enum.valueOf(this.enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public abstract void applyTo(E var1, T var2, Origin var3);
}

