/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.resolver.TsArtifact;
import io.quarkus.bootstrap.resolver.TsJar;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class TsRepoBuilder {
    protected final Path workDir;
    private final MavenArtifactResolver resolver;

    private static void error(String message, Throwable t) {
        throw new IllegalStateException(message, t);
    }

    public static TsRepoBuilder getInstance(MavenArtifactResolver resolver, Path workDir) {
        return new TsRepoBuilder(resolver, workDir);
    }

    private TsRepoBuilder(MavenArtifactResolver resolver, Path workDir) {
        this.resolver = resolver;
        this.workDir = workDir;
    }

    public void install(TsArtifact artifact) {
        try {
            this.install(artifact, artifact.content == null ? null : artifact.content.getPath(this.workDir));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize content for " + String.valueOf(artifact), e);
        }
    }

    public void install(TsArtifact artifact, Path p) {
        Path pomXml = this.workDir.resolve(artifact.getArtifactFileName() + ".pom");
        if (Files.exists(pomXml, new LinkOption[0])) {
            return;
        }
        try {
            ModelUtils.persistModel((Path)pomXml, (Model)artifact.getPomModel());
        }
        catch (Exception e) {
            TsRepoBuilder.error("Failed to persist pom.xml for " + String.valueOf(artifact), e);
        }
        this.install(artifact.toPomArtifact().toArtifact(), pomXml);
        if (p == null) {
            switch (artifact.type) {
                case "jar": {
                    try {
                        p = this.newJar().addMavenMetadata(artifact, pomXml).getPath(this.workDir);
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to install " + String.valueOf(artifact), e);
                    }
                }
                case "txt": {
                    p = this.newTxt(artifact);
                    break;
                }
                case "pom": {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported artifact type " + artifact.type);
                }
            }
        }
        if (p != null) {
            this.install(artifact.toArtifact(), p);
        }
    }

    protected void install(ArtifactCoords artifact, Path file) {
        try {
            this.resolver.install((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), Map.of(), file.toFile()));
        }
        catch (BootstrapMavenException e) {
            TsRepoBuilder.error("Failed to install " + String.valueOf(artifact), e);
        }
    }

    protected Path newTxt(TsArtifact artifact) {
        Path tmpFile = this.workDir.resolve(artifact.getArtifactFileName());
        if (Files.exists(tmpFile, new LinkOption[0])) {
            throw new IllegalStateException("File already exists " + String.valueOf(tmpFile));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(tmpFile, new OpenOption[0]);){
            writer.write(tmpFile.getFileName().toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create file " + String.valueOf(tmpFile), e);
        }
        return tmpFile;
    }

    public TsJar newJar() {
        return new TsJar(this.workDir.resolve(UUID.randomUUID().toString()));
    }
}

