/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.avro.deployment;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public abstract class AvroCodeGenProviderBase
implements CodeGenProvider {
    private static final Logger log = Logger.getLogger(AvroCodeGenProviderBase.class);
    public static final String[] EMPTY = new String[0];
    static final String templateDirectory = "/org/apache/avro/compiler/specific/templates/java/classic/";

    public String inputDirectory() {
        return "avro";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        this.init();
        boolean filesGenerated = false;
        AvroOptions options = new AvroOptions(context.config());
        Path input = context.inputDir();
        Path outputDir = context.outDir();
        HashSet<Path> importedPaths = new HashSet<Path>();
        for (String imprt : options.imports) {
            Path importPath = input.resolve(imprt.trim()).toAbsolutePath().normalize();
            if (Files.isDirectory(importPath, new LinkOption[0])) {
                log.infof("Importing Directory: %s", (Object)importPath);
                Collection<Path> files = this.gatherAllFiles(importPath);
                log.debugf("Importing Directory Files: %s", files);
                for (Path file : files) {
                    this.compileSingleFile(file, outputDir, options);
                    importedPaths.add(file);
                    filesGenerated = true;
                }
                continue;
            }
            if (!Files.exists(importPath, new LinkOption[0])) continue;
            log.infof("Importing File: %s", (Object)importPath);
            this.compileSingleFile(importPath, outputDir, options);
            importedPaths.add(importPath);
            filesGenerated = true;
        }
        for (Path file : this.gatherAllFiles(input)) {
            if (importedPaths.contains(file)) continue;
            this.compileSingleFile(file, outputDir, options);
            filesGenerated = true;
        }
        return filesGenerated;
    }

    abstract void init();

    private Collection<Path> gatherAllFiles(Path importPath) throws CodeGenException {
        if (!Files.exists(importPath, new LinkOption[0])) {
            return Collections.emptySet();
        }
        try {
            return Files.find(importPath, 20, (path, ignored) -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith("." + this.inputExtension()), new FileVisitOption[0]).map(Path::toAbsolutePath).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to list matching files in " + importPath, (Throwable)e);
        }
    }

    abstract void compileSingleFile(Path var1, Path var2, AvroOptions var3) throws CodeGenException;

    public String[] getImports(Config config) {
        return config.getOptionalValue("avro.codegen." + this.inputExtension() + ".imports", String.class).map(i -> i.split(",")).orElse(EMPTY);
    }

    public boolean shouldRun(Path sourceDir, Config config) {
        return super.shouldRun(sourceDir, config) || this.hasImportsConfig(config);
    }

    private boolean hasImportsConfig(Config config) {
        return this.getImports(config).length > 0;
    }

    public class AvroOptions {
        private final Config config;
        final String[] imports;
        final GenericData.StringType stringType;
        final boolean createOptionalGetters;
        final boolean enableDecimalLogicalType;
        final boolean createSetters;
        final boolean gettersReturnOptional;
        final boolean optionalGettersForNullableFieldsOnly;
        final List<String> customConversions = new ArrayList<String>();

        AvroOptions(Config config) {
            this.config = config;
            this.imports = AvroCodeGenProviderBase.this.getImports(config);
            this.stringType = GenericData.StringType.valueOf((String)this.prop("avro.codegen.stringType", "String"));
            this.createOptionalGetters = this.getBooleanProperty("avro.codegen.createOptionalGetters", false);
            this.enableDecimalLogicalType = this.getBooleanProperty("avro.codegen.enableDecimalLogicalType", false);
            this.createSetters = this.getBooleanProperty("avro.codegen.createSetters", true);
            this.gettersReturnOptional = this.getBooleanProperty("avro.codegen.gettersReturnOptional", false);
            this.optionalGettersForNullableFieldsOnly = this.getBooleanProperty("avro.codegen.optionalGettersForNullableFieldsOnly", false);
            String conversions = this.prop("avro.codegen.customConversions", "");
            if (!"".equals(conversions)) {
                for (String conversion : conversions.split(",")) {
                    this.customConversions.add(conversion.trim());
                }
            }
        }

        private String prop(String propName, String defaultValue) {
            return this.config.getOptionalValue(propName, String.class).orElse(defaultValue);
        }

        private boolean getBooleanProperty(String propName, boolean defaultValue) {
            String value = this.prop(propName, String.valueOf(defaultValue)).toLowerCase(Locale.ROOT);
            if (Boolean.FALSE.toString().equals(value)) {
                return false;
            }
            if (Boolean.TRUE.toString().equals(value)) {
                return true;
            }
            return defaultValue;
        }
    }
}

