/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.builder.item.SimpleBuildItem;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public final class TransformedAnnotationsBuildItem
extends SimpleBuildItem
implements Function<AnnotationTarget, Collection<AnnotationInstance>> {
    private final BeanDeployment beanDeployment;

    TransformedAnnotationsBuildItem(BeanDeployment beanDeployment) {
        this.beanDeployment = beanDeployment;
    }

    public Collection<AnnotationInstance> getAnnotations(AnnotationTarget target) {
        return this.queryAndConditionallyFilter(target);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target, DotName annotationName) {
        if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
            return this.queryForMethodParam(target, annotationName);
        }
        return this.beanDeployment.getAnnotation(target, annotationName);
    }

    public AnnotationInstance getAnnotation(AnnotationTarget target, Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(target, DotName.createSimple(annotationClass));
    }

    public boolean hasAnnotation(AnnotationTarget target, DotName annotationName) {
        if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
            return this.queryForMethodParam(target, annotationName) != null;
        }
        return this.beanDeployment.hasAnnotation(target, annotationName);
    }

    public boolean hasAnnotation(AnnotationTarget target, Class<? extends Annotation> annotationClass) {
        return this.hasAnnotation(target, DotName.createSimple(annotationClass));
    }

    @Override
    public Collection<AnnotationInstance> apply(AnnotationTarget target) {
        return this.queryAndConditionallyFilter(target);
    }

    private Collection<AnnotationInstance> queryAndConditionallyFilter(AnnotationTarget target) {
        if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
            ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
            for (AnnotationInstance instance : this.beanDeployment.getAnnotations((AnnotationTarget)target.asMethodParameter().method())) {
                if (!instance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) || instance.target().asMethodParameter().position() != target.asMethodParameter().position()) continue;
                result.add(instance);
            }
            return result;
        }
        return this.beanDeployment.getAnnotations(target);
    }

    private AnnotationInstance queryForMethodParam(AnnotationTarget target, DotName annotationName) {
        if (!target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
            throw new IllegalArgumentException("TransformedAnnotationsBuildItem#queryForMethodParam needs to operate on METHOD_PARAMETER AnnotationTarget");
        }
        for (AnnotationInstance instance : this.beanDeployment.getAnnotations((AnnotationTarget)target.asMethodParameter().method())) {
            if (!instance.name().equals((Object)annotationName) || !instance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER) || instance.target().asMethodParameter().position() != target.asMethodParameter().position()) continue;
            return instance;
        }
        return null;
    }
}

