/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.enterprise.inject.AmbiguousResolutionException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

class BeanResolverImpl
implements BeanResolver {
    private final BeanDeployment beanDeployment;
    private final ConcurrentMap<DotName, Set<DotName>> assignableFromMap;
    private final Function<DotName, Set<DotName>> assignableFromMapFunction;
    private final Map<InjectionPointInfo.TypeAndQualifiers, List<BeanInfo>> resolved;

    BeanResolverImpl(BeanDeployment beanDeployment) {
        this.beanDeployment = beanDeployment;
        this.assignableFromMap = new ConcurrentHashMap<DotName, Set<DotName>>();
        this.assignableFromMapFunction = name -> {
            HashSet<DotName> assignables = new HashSet<DotName>();
            for (ClassInfo subclass : beanDeployment.getBeanArchiveIndex().getAllKnownSubclasses(name)) {
                assignables.add(subclass.name());
            }
            for (ClassInfo implementor : beanDeployment.getBeanArchiveIndex().getAllKnownImplementors(name)) {
                assignables.add(implementor.name());
            }
            if (beanDeployment.hasApplicationIndex()) {
                for (ClassInfo subclass : beanDeployment.getApplicationIndex().getAllKnownSubclasses(name)) {
                    assignables.add(subclass.name());
                }
                for (ClassInfo implementor : beanDeployment.getApplicationIndex().getAllKnownImplementors(name)) {
                    assignables.add(implementor.name());
                }
            }
            return assignables;
        };
        this.resolved = new ConcurrentHashMap<InjectionPointInfo.TypeAndQualifiers, List<BeanInfo>>();
    }

    @Override
    public Set<BeanInfo> resolveBeans(Type requiredType, AnnotationInstance ... requiredQualifiers) {
        Set<AnnotationInstance> qualifiers;
        Objects.requireNonNull(requiredType, "Required type must not be null");
        if (requiredQualifiers.length == 0) {
            qualifiers = Collections.emptySet();
        } else {
            qualifiers = new HashSet();
            Collections.addAll(qualifiers, requiredQualifiers);
        }
        InjectionPointInfo.TypeAndQualifiers typeAndQualifiers = new InjectionPointInfo.TypeAndQualifiers(requiredType, qualifiers);
        List<BeanInfo> beans = this.findMatching(typeAndQualifiers);
        Set<BeanInfo> ret = beans.isEmpty() ? Collections.emptySet() : (beans.size() == 1 ? Collections.singleton(beans.get(0)) : new HashSet<BeanInfo>(beans));
        return ret;
    }

    @Override
    public BeanInfo resolveAmbiguity(Set<BeanInfo> beans) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        if (beans.size() > 1) {
            BeanInfo selected = Beans.resolveAmbiguity(beans);
            if (selected != null) {
                return selected;
            }
            throw new AmbiguousResolutionException(beans.toString());
        }
        return beans.iterator().next();
    }

    List<BeanInfo> resolve(InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        return this.resolved.computeIfAbsent(typeAndQualifiers, this::findMatching);
    }

    private List<BeanInfo> findMatching(InjectionPointInfo.TypeAndQualifiers typeAndQualifiers) {
        ArrayList resolved = new ArrayList();
        for (BeanInfo b : this.beanDeployment.getBeans()) {
            if (!Beans.matches(b, typeAndQualifiers)) continue;
            resolved.add(b);
        }
        return resolved.isEmpty() ? Collections.emptyList() : resolved;
    }

    List<BeanInfo> findTypeMatching(Type type) {
        ArrayList resolved = new ArrayList();
        for (BeanInfo b : this.beanDeployment.getBeans()) {
            if (!Beans.matchesType(b, type)) continue;
            resolved.add(b);
        }
        return resolved.isEmpty() ? Collections.emptyList() : resolved;
    }

    boolean matches(Type requiredType, Type beanType) {
        return this.matchesNoBoxing(Types.box(requiredType), Types.box(beanType));
    }

    boolean matchesNoBoxing(Type requiredType, Type beanType) {
        if (requiredType == beanType) {
            return true;
        }
        if (Type.Kind.ARRAY.equals((Object)requiredType.kind())) {
            if (Type.Kind.ARRAY.equals((Object)beanType.kind())) {
                return this.matchesNoBoxing(requiredType.asArrayType().component(), beanType.asArrayType().component());
            }
        } else if (Type.Kind.CLASS.equals((Object)requiredType.kind())) {
            if (Type.Kind.CLASS.equals((Object)beanType.kind())) {
                return requiredType.name().equals((Object)beanType.name());
            }
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)beanType.kind())) {
                if (!requiredType.name().equals((Object)beanType.asParameterizedType().name())) {
                    return false;
                }
                return BeanResolverImpl.containsUnboundedTypeVariablesOrObjects(beanType.asParameterizedType().arguments());
            }
        } else if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)requiredType.kind())) {
            if (Type.Kind.CLASS.equals((Object)beanType.kind())) {
                if (!beanType.name().equals((Object)requiredType.asParameterizedType().name())) {
                    return false;
                }
                return BeanResolverImpl.containsUnboundedTypeVariablesOrObjects(requiredType.asParameterizedType().arguments());
            }
            if (Type.Kind.PARAMETERIZED_TYPE.equals((Object)beanType.kind())) {
                if (!requiredType.name().equals((Object)beanType.name())) {
                    return false;
                }
                List requiredTypeArguments = requiredType.asParameterizedType().arguments();
                List beanTypeArguments = beanType.asParameterizedType().arguments();
                if (requiredTypeArguments.size() != beanTypeArguments.size()) {
                    throw new IllegalArgumentException("Invalid argument combination " + requiredType + "; " + beanType);
                }
                for (int i = 0; i < requiredTypeArguments.size(); ++i) {
                    if (this.parametersMatch((Type)requiredTypeArguments.get(i), (Type)beanTypeArguments.get(i))) continue;
                    return false;
                }
                return true;
            }
        } else if (Type.Kind.WILDCARD_TYPE.equals((Object)requiredType.kind())) {
            return this.parametersMatch(requiredType, beanType);
        }
        return false;
    }

    boolean parametersMatch(Type requiredParameter, Type beanParameter) {
        if (BeanResolverImpl.isActualType(requiredParameter) && BeanResolverImpl.isActualType(beanParameter)) {
            return this.matches(requiredParameter, beanParameter);
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)requiredParameter.kind()) && BeanResolverImpl.isActualType(beanParameter)) {
            return this.parametersMatch(requiredParameter.asWildcardType(), beanParameter);
        }
        if (Type.Kind.WILDCARD_TYPE.equals((Object)requiredParameter.kind()) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(requiredParameter.asWildcardType(), beanParameter.asTypeVariable());
        }
        if (BeanResolverImpl.isActualType(requiredParameter) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(requiredParameter, beanParameter.asTypeVariable());
        }
        if (Type.Kind.TYPE_VARIABLE.equals((Object)requiredParameter.kind()) && Type.Kind.TYPE_VARIABLE.equals((Object)beanParameter.kind())) {
            return this.parametersMatch(requiredParameter.asTypeVariable(), beanParameter.asTypeVariable());
        }
        return false;
    }

    boolean parametersMatch(WildcardType requiredParameter, Type beanParameter) {
        return this.lowerBoundsOfWildcardMatch(beanParameter, requiredParameter) && this.upperBoundsOfWildcardMatch(requiredParameter, beanParameter);
    }

    boolean parametersMatch(WildcardType requiredParameter, TypeVariable beanParameter) {
        List<Type> beanParameterBounds = this.getUppermostTypeVariableBounds(beanParameter);
        if (!this.lowerBoundsOfWildcardMatch(beanParameterBounds, requiredParameter)) {
            return false;
        }
        List<Type> requiredUpperBounds = Collections.singletonList(requiredParameter.extendsBound());
        return this.boundsMatch(requiredUpperBounds, beanParameterBounds) || this.boundsMatch(beanParameterBounds, requiredUpperBounds);
    }

    boolean parametersMatch(Type requiredParameter, TypeVariable beanParameter) {
        for (Type bound : this.getUppermostTypeVariableBounds(beanParameter)) {
            if (this.isAssignableFrom(bound, requiredParameter)) continue;
            return false;
        }
        return true;
    }

    boolean parametersMatch(TypeVariable requiredParameter, TypeVariable beanParameter) {
        return this.boundsMatch(this.getUppermostTypeVariableBounds(beanParameter), this.getUppermostTypeVariableBounds(requiredParameter));
    }

    boolean boundsMatch(List<Type> bounds, List<Type> stricterBounds) {
        bounds = this.getUppermostBounds(bounds);
        stricterBounds = this.getUppermostBounds(stricterBounds);
        for (Type bound : bounds) {
            for (Type stricterBound : stricterBounds) {
                if (this.isAssignableFrom(bound, stricterBound)) continue;
                return false;
            }
        }
        return true;
    }

    boolean isAssignableFrom(Type type1, Type type2) {
        if (type1.name().equals((Object)DotNames.OBJECT)) {
            return true;
        }
        if (type1.name().equals((Object)type2.name())) {
            return true;
        }
        return this.assignableFromMap.computeIfAbsent(type1.name(), this.assignableFromMapFunction).contains(type2.name());
    }

    boolean lowerBoundsOfWildcardMatch(Type parameter, WildcardType requiredParameter) {
        return this.lowerBoundsOfWildcardMatch(Collections.singletonList(parameter), requiredParameter);
    }

    boolean lowerBoundsOfWildcardMatch(List<Type> beanParameterBounds, WildcardType requiredParameter) {
        return requiredParameter.superBound() == null || this.boundsMatch(beanParameterBounds, Collections.singletonList(requiredParameter.superBound()));
    }

    boolean upperBoundsOfWildcardMatch(WildcardType requiredParameter, Type parameter) {
        return this.boundsMatch(Collections.singletonList(requiredParameter.extendsBound()), Collections.singletonList(parameter));
    }

    List<Type> getUppermostTypeVariableBounds(TypeVariable bound) {
        if (Type.Kind.TYPE_VARIABLE.equals((Object)((Type)bound.bounds().get(0)).kind())) {
            return this.getUppermostTypeVariableBounds(((Type)bound.bounds().get(0)).asTypeVariable());
        }
        return bound.bounds();
    }

    List<Type> getUppermostBounds(List<Type> bounds) {
        if (Type.Kind.TYPE_VARIABLE.equals((Object)bounds.get(0).kind())) {
            return this.getUppermostTypeVariableBounds(bounds.get(0).asTypeVariable());
        }
        return bounds;
    }

    static boolean isActualType(Type type) {
        return Type.Kind.CLASS.equals((Object)type.kind()) || Type.Kind.PARAMETERIZED_TYPE.equals((Object)type.kind()) || Type.Kind.ARRAY.equals((Object)type.kind());
    }

    static boolean containsUnboundedTypeVariablesOrObjects(List<Type> types) {
        for (Type type : types) {
            List bounds;
            if (ClassType.OBJECT_TYPE.equals((Object)type) || Type.Kind.TYPE_VARIABLE.equals((Object)type.kind()) && ((bounds = type.asTypeVariable().bounds()).isEmpty() || bounds.size() == 1 && ClassType.OBJECT_TYPE.equals(bounds.get(0)))) continue;
            return false;
        }
        return true;
    }
}

