/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.web.bundler.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;

@Recorder
public class BundleRedirectHandlerRecorder {
    public Handler<RoutingContext> handler(Map<String, String> bundle) {
        return event -> {
            String path = event.normalizedPath();
            String entryPoint = path.substring(path.lastIndexOf(47) + 1);
            if (!bundle.containsKey(entryPoint)) {
                event.next();
                return;
            }
            event.response().setStatusCode(302);
            event.response().putHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            event.response().putHeader("Location", (String)bundle.get(entryPoint));
            event.response().end();
        };
    }
}

