/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.HTTPConduitImpl;
import io.quarkiverse.cxf.HTTPConduitSpec;
import io.quarkiverse.cxf.vertx.http.client.HttpClientPool;
import io.quarkus.logging.Log;
import io.vertx.core.Vertx;
import java.io.IOException;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpClientHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.jboss.logging.Logger;

public class QuarkusHTTPConduitFactory
implements HTTPConduitFactory {
    static final Logger log = Logger.getLogger(QuarkusHTTPConduitFactory.class);
    public static final String QUARKUS_CXF_DEFAULT_HTTP_CONDUIT_FACTORY = "QUARKUS_CXF_DEFAULT_HTTP_CONDUIT_FACTORY";
    static HTTPConduitImpl defaultHTTPConduitImpl;
    private final CxfFixedConfig cxFixedConfig;
    private final CXFClientInfo cxfClientInfo;
    private final HTTPConduitSpec busHTTPConduitImpl;
    private final AuthorizationPolicy authorizationPolicy;
    private final Vertx vertx;
    private final HttpClientPool httpClientPool;

    public QuarkusHTTPConduitFactory(CxfFixedConfig cxFixedConfig, CXFClientInfo cxfClientInfo, HTTPConduitSpec busHTTPConduitImpl, AuthorizationPolicy authorizationPolicy, Vertx vertx, HttpClientPool httpClientPool) {
        this.cxFixedConfig = cxFixedConfig;
        this.cxfClientInfo = cxfClientInfo;
        this.busHTTPConduitImpl = busHTTPConduitImpl;
        this.authorizationPolicy = authorizationPolicy;
        this.vertx = vertx;
        this.httpClientPool = httpClientPool;
    }

    public HTTPConduit createConduit(HTTPTransportFactory f, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        HTTPConduitSpec httpConduitImpl = this.cxfClientInfo.getHttpConduitImpl();
        if (httpConduitImpl == null) {
            httpConduitImpl = this.cxFixedConfig.httpConduitFactory().orElse(null);
        }
        if (httpConduitImpl == null && CXFRecorder.isHc5Present() && this.busHTTPConduitImpl != null) {
            return this.configure(this.busHTTPConduitImpl.resolveDefault(), this.cxfClientInfo, b, localInfo, target);
        }
        if (httpConduitImpl == null) {
            httpConduitImpl = HTTPConduitImpl.QuarkusCXFDefault;
        }
        return this.configure(httpConduitImpl.resolveDefault(), this.cxfClientInfo, b, localInfo, target);
    }

    private HTTPConduit configure(HTTPConduitSpec httpConduitImpl, CXFClientInfo cxfClientInfo, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        HTTPConduit httpConduit = httpConduitImpl.createConduit(cxfClientInfo, this.httpClientPool, b, localInfo, target);
        if (httpConduit instanceof HttpClientHTTPConduit) {
            Log.warnf((String)"Usage of %s is deprecated since Quarkus CXF 3.18.0. You may want to review the options quarkus.cxf.http-conduit-factory and/or quarkus.cxf.client.\"%s\".http-conduit-factory", (Object)HttpClientHTTPConduit.class.getName(), (Object)cxfClientInfo.getConfigKey());
        }
        httpConduitImpl.tlsClientParameters(cxfClientInfo, this.vertx).ifPresent(arg_0 -> ((HTTPConduit)httpConduit).setTlsClientParameters(arg_0));
        HTTPClientPolicy policy = new HTTPClientPolicy();
        httpConduit.setClient(policy);
        policy.setConnectionTimeout(cxfClientInfo.getConnectionTimeout().longValue());
        policy.setReceiveTimeout(cxfClientInfo.getReceiveTimeout().longValue());
        policy.setConnectionRequestTimeout(cxfClientInfo.getConnectionRequestTimeout().longValue());
        policy.setAutoRedirect(cxfClientInfo.isAutoRedirect());
        policy.setMaxRetransmits(cxfClientInfo.getMaxRetransmits());
        policy.setAllowChunking(cxfClientInfo.isAllowChunking());
        policy.setChunkingThreshold(cxfClientInfo.getChunkingThreshold());
        policy.setChunkLength(cxfClientInfo.getChunkLength());
        Object value = cxfClientInfo.getAccept();
        if (value != null) {
            policy.setAccept((String)value);
        }
        if ((value = cxfClientInfo.getAcceptLanguage()) != null) {
            policy.setAcceptLanguage((String)value);
        }
        if ((value = cxfClientInfo.getAcceptEncoding()) != null) {
            policy.setAcceptEncoding((String)value);
        }
        if ((value = cxfClientInfo.getContentType()) != null) {
            policy.setContentType((String)value);
        }
        if ((value = cxfClientInfo.getHost()) != null) {
            policy.setHost((String)value);
        }
        policy.setConnection(cxfClientInfo.getConnection());
        value = cxfClientInfo.getCacheControl();
        if (value != null) {
            policy.setCacheControl((String)value);
        }
        policy.setVersion(cxfClientInfo.getVersion());
        value = cxfClientInfo.getBrowserType();
        if (value != null) {
            policy.setBrowserType((String)value);
        }
        if ((value = cxfClientInfo.getDecoupledEndpoint()) != null) {
            policy.setDecoupledEndpoint((String)value);
        }
        if ((value = cxfClientInfo.getProxyServer()) != null) {
            policy.setProxyServer((String)value);
        }
        if ((value = cxfClientInfo.getProxyServerPort()) != null) {
            policy.setProxyServerPort((Integer)value);
        }
        if ((value = cxfClientInfo.getNonProxyHosts()) != null) {
            policy.setNonProxyHosts((String)value);
        }
        policy.setProxyServerType(cxfClientInfo.getProxyServerType());
        String proxyUsername = cxfClientInfo.getProxyUsername();
        if (proxyUsername != null) {
            String proxyPassword = cxfClientInfo.getProxyPassword();
            ProxyAuthorizationPolicy proxyAuth = new ProxyAuthorizationPolicy();
            proxyAuth.setUserName(proxyUsername);
            proxyAuth.setPassword(proxyPassword);
            httpConduit.setProxyAuthorization(proxyAuth);
        }
        if (this.authorizationPolicy != null && cxfClientInfo.isSecureWsdlAccess()) {
            httpConduit.setAuthorization(this.authorizationPolicy);
        }
        return httpConduit;
    }
}

