/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.ConnectionTypeConverter;
import io.quarkiverse.cxf.HTTPConduitImpl;
import io.quarkiverse.cxf.LoggingConfig;
import io.quarkus.runtime.annotations.ConfigDocEnum;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.List;
import java.util.Optional;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@ConfigGroup
public interface CxfClientConfig {
    @WithName(value="wsdl")
    public Optional<String> wsdlPath();

    public Optional<String> soapBinding();

    public Optional<String> clientEndpointUrl();

    public Optional<String> endpointNamespace();

    public Optional<String> endpointName();

    @Deprecated
    public Optional<String> username();

    @Deprecated
    public Optional<String> password();

    public Auth auth();

    @WithDefault(value="false")
    public boolean secureWsdlAccess();

    public LoggingConfig.PerClientOrServiceLoggingConfig logging();

    public Optional<List<String>> features();

    public Optional<List<String>> handlers();

    public Optional<List<String>> inInterceptors();

    public Optional<List<String>> outInterceptors();

    public Optional<List<String>> outFaultInterceptors();

    public Optional<List<String>> inFaultInterceptors();

    @WithDefault(value="30000")
    public long connectionTimeout();

    @WithDefault(value="60000")
    public long receiveTimeout();

    @WithDefault(value="60000")
    public long connectionRequestTimeout();

    @WithDefault(value="false")
    public boolean autoRedirect();

    @WithDefault(value="false")
    public boolean redirectRelativeUri();

    @WithDefault(value="-1")
    public int maxRetransmits();

    @WithDefault(value="0")
    public int maxSameUri();

    @WithDefault(value="true")
    public boolean allowChunking();

    @WithDefault(value="4096")
    public int chunkingThreshold();

    @WithDefault(value="-1")
    public int chunkLength();

    public Optional<String> accept();

    public Optional<String> acceptLanguage();

    public Optional<String> acceptEncoding();

    public Optional<String> contentType();

    public Optional<String> host();

    @WithDefault(value="keep-alive")
    @WithConverter(value=ConnectionTypeConverter.class)
    @ConfigDocEnum(enforceHyphenateValues=true)
    public ConnectionType connection();

    public Optional<String> cacheControl();

    @WithDefault(value="auto")
    public String version();

    public Optional<String> browserType();

    public Optional<String> decoupledEndpoint();

    public Optional<String> proxyServer();

    public Optional<Integer> proxyServerPort();

    public Optional<String> nonProxyHosts();

    @WithDefault(value="HTTP")
    public ProxyServerType proxyServerType();

    public Optional<String> proxyUsername();

    public Optional<String> proxyPassword();

    public Optional<HTTPConduitImpl> httpConduitFactory();

    public Optional<String> tlsConfigurationName();

    @Deprecated
    public Optional<String> keyStore();

    @Deprecated
    public Optional<String> keyStorePassword();

    @WithDefault(value="JKS")
    @Deprecated
    public String keyStoreType();

    @Deprecated
    public Optional<String> keyPassword();

    @Deprecated
    public Optional<String> trustStore();

    @Deprecated
    public Optional<String> trustStorePassword();

    @WithDefault(value="JKS")
    @Deprecated
    public String trustStoreType();

    public Optional<String> hostnameVerifier();

    @WithName(value="schema-validation.enabled-for")
    public Optional<SchemaValidation.SchemaValidationType> schemaValidationEnabledFor();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum WellKnownHostnameVerifier {
        AllowAllHostnameVerifier{

            @Override
            public void configure(TLSClientParameters params) {
                params.setDisableCNCheck(true);
            }
        }
        ,
        HttpsURLConnectionDefaultHostnameVerifier{

            @Override
            public void configure(TLSClientParameters params) {
                params.setUseHttpsURLConnectionDefaultHostnameVerifier(true);
            }
        };


        public abstract void configure(TLSClientParameters var1);

        public static Optional<WellKnownHostnameVerifier> of(String name) {
            if (name == null) {
                return Optional.empty();
            }
            for (WellKnownHostnameVerifier item : WellKnownHostnameVerifier.values()) {
                if (!item.name().equals(name)) continue;
                return Optional.of(item);
            }
            return Optional.empty();
        }
    }

    public static interface Auth {
        public Optional<String> username();

        public Optional<String> password();

        public Optional<String> scheme();

        public Optional<String> token();
    }
}

