/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.annotations.SchemaValidation;
import org.jboss.logging.Logger;

public class CXFServletInfo {
    private final String relativePath;
    private final String path;
    private final Class<?> implementor;
    private final List<String> inInterceptors;
    private final List<String> outInterceptors;
    private final List<String> outFaultInterceptors;
    private final List<String> inFaultInterceptors;
    private final List<String> features;
    private final List<String> handlers;
    private final Class<?> sei;
    private final String wsdlPath;
    private final String serviceName;
    private final String serviceTargetNamespace;
    private final String soapBinding;
    private final Boolean isProvider;
    private final String endpointUrl;
    private final SchemaValidation.SchemaValidationType schemaValidationEnabledFor;
    private final MessagePassingQueue.Supplier<Object> beanLookup;
    private static final Logger LOGGER = Logger.getLogger(CXFServletInfo.class);

    public CXFServletInfo(String path, String relativePath, Class<?> implementor, Class<?> sei, String wsdlPath, String serviceName, String serviceTargetNamespace, String soapBinding, Boolean provider, String endpointUrl, SchemaValidation.SchemaValidationType schemaValidationEnabledFor, MessagePassingQueue.Supplier<Object> beanLookup) {
        LOGGER.trace((Object)"new CXFServletInfo");
        this.path = path;
        this.relativePath = relativePath;
        this.implementor = implementor;
        this.inInterceptors = new ArrayList<String>();
        this.outInterceptors = new ArrayList<String>();
        this.outFaultInterceptors = new ArrayList<String>();
        this.inFaultInterceptors = new ArrayList<String>();
        this.features = new ArrayList<String>();
        this.handlers = new ArrayList<String>();
        this.sei = sei;
        this.wsdlPath = wsdlPath;
        this.serviceName = serviceName;
        this.serviceTargetNamespace = serviceTargetNamespace;
        this.soapBinding = soapBinding;
        this.isProvider = provider;
        this.endpointUrl = endpointUrl;
        this.schemaValidationEnabledFor = schemaValidationEnabledFor;
        this.beanLookup = beanLookup;
    }

    public String getClassName() {
        return this.implementor.getName();
    }

    public Class<?> getImplementor() {
        return this.implementor;
    }

    public String getPath() {
        return this.path;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getWsdlPath() {
        return this.wsdlPath;
    }

    public Class<?> getSei() {
        return this.sei;
    }

    public List<String> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public List<String> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public List<String> getInInterceptors() {
        return Collections.unmodifiableList(this.inInterceptors);
    }

    public List<String> getOutInterceptors() {
        return Collections.unmodifiableList(this.outInterceptors);
    }

    public List<String> getOutFaultInterceptors() {
        return Collections.unmodifiableList(this.outFaultInterceptors);
    }

    public List<String> getInFaultInterceptors() {
        return Collections.unmodifiableList(this.inFaultInterceptors);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceTargetNamespace() {
        return this.serviceTargetNamespace;
    }

    public String getSOAPBinding() {
        return this.soapBinding;
    }

    public Boolean isProvider() {
        return this.isProvider;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public SchemaValidation.SchemaValidationType getSchemaValidationEnabledFor() {
        return this.schemaValidationEnabledFor;
    }

    public <T> T lookupBean() {
        return (T)this.beanLookup.get();
    }

    public void addFeatures(List<String> features) {
        this.features.addAll(features);
    }

    public void addHandlers(List<String> handlers) {
        this.handlers.addAll(handlers);
    }

    public void addInInterceptors(List<String> inInterceptors) {
        this.inInterceptors.addAll(inInterceptors);
    }

    public void addOutInterceptors(List<String> outInterceptors) {
        this.outInterceptors.addAll(outInterceptors);
    }

    public void addOutFaultInterceptors(List<String> outFaultInterceptors) {
        this.outFaultInterceptors.addAll(outFaultInterceptors);
    }

    public void addInFaultInterceptors(List<String> inFaultInterceptors) {
        this.inFaultInterceptors.addAll(inFaultInterceptors);
    }

    public String toString() {
        return "Web Service " + this.implementor.getName() + " on " + this.path;
    }
}

